/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.EngineInfo;
import org.flowable.engine.common.impl.util.ReflectUtil;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, FormEngine> formEngines;
    protected static Map<String, EngineInfo> formEngineInfosByName;
    protected static Map<String, EngineInfo> formEngineInfosByResourceUrl;
    protected static List<EngineInfo> formEngineInfos;

    public static synchronized void init() {
        if (!FormEngines.isInitialized()) {
            if (formEngines == null) {
                formEngines = new HashMap<String, FormEngine>();
            }
            ClassLoader classLoader = FormEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("flowable.form.cfg.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable.form.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                LOGGER.info("Initializing form engine using configuration '{}'", (Object)resource.toString());
                FormEngines.initFormEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("flowable-form-context.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable-form-context.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                LOGGER.info("Initializing form engine using Spring configuration '{}'", (Object)resource.toString());
                FormEngines.initFormEngineFromSpringResource(resource);
            }
            FormEngines.setInitialized(true);
        } else {
            LOGGER.info("Form engines already initialized");
        }
    }

    protected static void initFormEngineFromSpringResource(URL resource) {
        try {
            Class springConfigurationHelperClass = ReflectUtil.loadClass((String)"org.flowable.form.spring.SpringFormConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildFormEngine", URL.class);
            FormEngine formEngine = (FormEngine)method.invoke(null, resource);
            String formEngineName = formEngine.getName();
            EngineInfo formEngineInfo = new EngineInfo(formEngineName, resource.toString(), null);
            formEngineInfosByName.put(formEngineName, formEngineInfo);
            formEngineInfosByResourceUrl.put(resource.toString(), formEngineInfo);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't initialize form engine from spring configuration resource " + resource.toString() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void registerFormEngine(FormEngine formEngine) {
        formEngines.put(formEngine.getName(), formEngine);
    }

    public static void unregister(FormEngine formEngine) {
        formEngines.remove(formEngine.getName());
    }

    private static EngineInfo initFormEngineFromResource(URL resourceUrl) {
        EngineInfo formEngineInfo = formEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (formEngineInfo != null) {
            formEngineInfos.remove(formEngineInfo);
            if (formEngineInfo.getException() == null) {
                String formEngineName = formEngineInfo.getName();
                formEngines.remove(formEngineName);
                formEngineInfosByName.remove(formEngineName);
            }
            formEngineInfosByResourceUrl.remove(formEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOGGER.info("initializing form engine for resource {}", (Object)resourceUrl);
            FormEngine formEngine = FormEngines.buildFormEngine(resourceUrl);
            String formEngineName = formEngine.getName();
            LOGGER.info("initialised form engine {}", (Object)formEngineName);
            formEngineInfo = new EngineInfo(formEngineName, resourceUrlString, null);
            formEngines.put(formEngineName, formEngine);
            formEngineInfosByName.put(formEngineName, formEngineInfo);
        }
        catch (Throwable e) {
            LOGGER.error("Exception while initializing form engine: {}", (Object)e.getMessage(), (Object)e);
            formEngineInfo = new EngineInfo(null, resourceUrlString, ExceptionUtils.getStackTrace((Throwable)e));
        }
        formEngineInfosByResourceUrl.put(resourceUrlString, formEngineInfo);
        formEngineInfos.add(formEngineInfo);
        return formEngineInfo;
    }

    protected static FormEngine buildFormEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            FormEngineConfiguration formEngineConfiguration = FormEngineConfiguration.createFormEngineConfigurationFromInputStream(inputStream);
            FormEngine formEngine = formEngineConfiguration.buildFormEngine();
            return formEngine;
        }
        catch (IOException e) {
            throw new FlowableException("couldn't open resource stream: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static List<EngineInfo> getFormEngineInfos() {
        return formEngineInfos;
    }

    public static EngineInfo getFormEngineInfo(String formEngineName) {
        return formEngineInfosByName.get(formEngineName);
    }

    public static FormEngine getDefaultFormEngine() {
        return FormEngines.getFormEngine(NAME_DEFAULT);
    }

    public static FormEngine getFormEngine(String formEngineName) {
        if (!FormEngines.isInitialized()) {
            FormEngines.init();
        }
        return formEngines.get(formEngineName);
    }

    public static EngineInfo retry(String resourceUrl) {
        LOGGER.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return FormEngines.initFormEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("invalid url: " + resourceUrl, (Throwable)e);
        }
    }

    public static Map<String, FormEngine> getFormEngines() {
        return formEngines;
    }

    public static synchronized void destroy() {
        if (FormEngines.isInitialized()) {
            HashMap<String, FormEngine> engines = new HashMap<String, FormEngine>(formEngines);
            formEngines = new HashMap<String, FormEngine>();
            for (String formEngineName : engines.keySet()) {
                FormEngine formEngine = (FormEngine)engines.get(formEngineName);
                try {
                    formEngine.close();
                }
                catch (Exception e) {
                    LOGGER.error("exception while closing {}", (Object)(formEngineName == null ? "the default form engine" : "form engine " + formEngineName), (Object)e);
                }
            }
            formEngineInfosByName.clear();
            formEngineInfosByResourceUrl.clear();
            formEngineInfos.clear();
            FormEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        FormEngines.isInitialized = isInitialized;
    }

    static {
        formEngines = new HashMap<String, FormEngine>();
        formEngineInfosByName = new HashMap<String, EngineInfo>();
        formEngineInfosByResourceUrl = new HashMap<String, EngineInfo>();
        formEngineInfos = new ArrayList<EngineInfo>();
    }
}

