/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;
import org.eweb4j.util.xml.AttrTag;
import org.eweb4j.util.xml.Readonly;
import org.eweb4j.util.xml.Skip;
import org.eweb4j.util.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanXMLWriter
implements XMLWriter {
    private boolean isCheckStatck = false;
    private boolean isSubNameAuto = false;
    private String rootElementName = "beans";
    private String beanName = "bean";
    private File file;
    private Collection<?> list;
    private Set<String> pool = new HashSet<String>();
    private Hashtable<String, Class<?>> classes = new Hashtable();

    @Override
    public void setClass(Class<?> clazz) {
        this.setClass(this.beanName, clazz);
    }

    @Override
    public void setClass(String key, Class<?> clazz) {
        block8: {
            Field[] fields;
            if (key == null || clazz == null) {
                return;
            }
            if (!ClassUtil.isPojo(clazz)) break block8;
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    Field f;
                    block12: {
                        block9: {
                            Class<?> cls;
                            block11: {
                                f = fieldArray[n2];
                                if (!Collection.class.isAssignableFrom(f.getType())) break block9;
                                ParameterizedType pt = (ParameterizedType)f.getGenericType();
                                Type type = pt.getActualTypeArguments()[0];
                                cls = ClassUtil.getPojoClass(type.toString().replace("class ", ""));
                                if (cls == null) break block10;
                                if (!this.isCheckStatck) break block11;
                                if (this.pool.contains(cls.getName())) break block10;
                                this.pool.add(cls.getName());
                            }
                            this.setClass(f.getName(), cls);
                            break block10;
                        }
                        if (!this.isCheckStatck) break block12;
                        if (this.pool.contains(f.getType().getName())) break block10;
                        this.pool.add(f.getType().getName());
                    }
                    this.setClass(f.getName(), f.getType());
                }
                ++n2;
            }
            this.classes.put(key, clazz);
        }
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void setRootElementName(String rootElementName) {
        this.rootElementName = rootElementName;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setList(Collection<?> list) {
        this.list = list;
    }

    public Collection<?> getList() {
        return this.list;
    }

    public BeanXMLWriter() {
    }

    public BeanXMLWriter(File file) {
        this.setFile(file);
    }

    public BeanXMLWriter(File file, Collection<?> list) {
        this.setFile(file);
        this.setList(list);
    }

    public BeanXMLWriter(File file, Class<?> ... clazzs) {
        this.setFile(file);
        ArrayList list = new ArrayList();
        Class<?>[] classArray = clazzs;
        int n = clazzs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            list.add(c);
            ++n2;
        }
        this.setList(list);
    }

    public <T> BeanXMLWriter(File file, T ... ts) {
        this.setFile(file);
        ArrayList<T> list = new ArrayList<T>();
        T[] TArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (Collection.class.isAssignableFrom(t.getClass())) {
                list.addAll((Collection)t);
            } else {
                list.add(t);
            }
            ++n2;
        }
        this.setList(list);
    }

    public <T> BeanXMLWriter(File file, Class<T> clazz) {
        this.setFile(file);
        ArrayList<T> list = new ArrayList<T>();
        try {
            list.add(clazz.newInstance());
            this.setList(list);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public <T> BeanXMLWriter(File file, T t) {
        this.setFile(file);
        ArrayList<T> list = new ArrayList<T>();
        if (Collection.class.isAssignableFrom(t.getClass())) {
            list.addAll((Collection)t);
        } else {
            list.add(t);
        }
        this.setList(list);
    }

    @Override
    public String toXml() throws Exception {
        return this.createDoc().asXML();
    }

    @Override
    public File write() throws Exception {
        Document doc = this.createDoc();
        FileOutputStream fos = new FileOutputStream(this.file);
        OutputFormat format = OutputFormat.createPrettyPrint();
        org.dom4j.io.XMLWriter xmlWriter = new org.dom4j.io.XMLWriter((OutputStream)fos, format);
        xmlWriter.write(doc);
        fos.close();
        xmlWriter.close();
        return this.file;
    }

    private Document createDoc() throws Exception {
        Document doc = DocumentHelper.createDocument();
        if ((this.rootElementName == null || this.rootElementName.trim().length() == 0) && this.list.size() == 1) {
            String name = this.beanName == null || this.beanName.trim().length() == 0 ? "bean" : this.beanName;
            Element bean = doc.addElement(name);
            for (Object t : this.list) {
                this.writeRecursion(bean, t);
            }
        } else {
            if (this.rootElementName == null || this.rootElementName.trim().length() == 0) {
                this.rootElementName = "beans";
            }
            Element beans = doc.addElement(this.rootElementName);
            String sub = this.beanName == null || this.beanName.trim().length() == 0 ? "bean" : this.beanName;
            for (Object t : this.list) {
                Element bean = this.isSubNameAuto ? beans.addElement(t.getClass().getSimpleName().toLowerCase()) : beans.addElement(sub);
                this.writeRecursion(bean, t);
            }
        }
        return doc;
    }

    private <T> void writeRecursion(Element bean, T t) throws Exception {
        Field[] fields;
        ReflectUtil ru = new ReflectUtil(t);
        Field[] fieldArray = fields = ru.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            String n3 = f.getName();
            Method m = ru.getGetter(n3);
            if (m != null) {
                if ("clazz".equals(n3)) {
                    n3 = "class";
                }
                Object obj = m.invoke(t, new Object[0]);
                Skip skip = f.getAnnotation(Skip.class);
                if (skip == null) {
                    AttrTag attrTag = f.getAnnotation(AttrTag.class);
                    Readonly readonly = f.getAnnotation(Readonly.class);
                    if (readonly == null) {
                        Collection list;
                        if (ClassUtil.isPojo(f.getType())) {
                            Class<?> cls = this.classes.get(n3);
                            if (cls != null) {
                                if (obj == null) {
                                    obj = cls.newInstance();
                                }
                                this.writeRecursion(bean.addElement(n3), cls.cast(obj));
                            }
                        } else if (attrTag != null) {
                            if (obj == null) {
                                obj = "";
                            }
                            bean.addAttribute(n3, String.valueOf(obj));
                        } else if (ClassUtil.isListClass(f)) {
                            list = (Collection)obj;
                            Class<?> cls = this.classes.get(n3);
                            if (list.size() == 0 && cls != null) {
                                this.writeRecursion(bean.addElement(n3), cls.newInstance());
                            } else {
                                Iterator it = list.iterator();
                                while (it.hasNext()) {
                                    this.writeRecursion(bean.addElement(n3), it.next());
                                }
                            }
                        } else if (ClassUtil.isListString(f)) {
                            list = (Collection)obj;
                            for (Object v2 : list) {
                                if (v2 == null) {
                                    v2 = "";
                                }
                                bean.addElement(n3).addText(String.valueOf(v2));
                            }
                        } else {
                            if (obj == null) {
                                obj = "";
                            }
                            bean.addElement(n3).addText(String.valueOf(obj));
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public boolean isSubNameAuto() {
        return this.isSubNameAuto;
    }

    @Override
    public void setSubNameAuto(boolean isSubNameAuto) {
        this.isSubNameAuto = isSubNameAuto;
    }

    @Override
    public void setCheckStatck(boolean isCheckStatck) {
        this.isCheckStatck = isCheckStatck;
    }
}

