/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util.xml;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;
import org.eweb4j.util.xml.AttrTag;
import org.eweb4j.util.xml.Skip;
import org.eweb4j.util.xml.Writeonly;
import org.eweb4j.util.xml.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanXMLReader
implements XMLReader {
    private String rootElementName;
    private String beanName;
    private File file;
    private Hashtable<String, Class<?>> classes = new Hashtable();

    @Override
    public void setClass(Class<?> clazz) {
        this.setClass(this.beanName, clazz);
    }

    @Override
    public void setClass(String key, Class<?> clazz) {
        if (ClassUtil.isPojo(clazz)) {
            Field[] fields;
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (List.class.isAssignableFrom(f.getType())) {
                    ParameterizedType pt = (ParameterizedType)f.getGenericType();
                    Type type = pt.getActualTypeArguments()[0];
                    Class<?> cls = ClassUtil.getPojoClass(type.toString().replace("class ", ""));
                    this.setClass(f.getName(), cls);
                } else {
                    this.setClass(f.getName(), f.getType());
                }
                ++n2;
            }
            this.classes.put(key, clazz);
        }
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void setRootElementName(String name) {
        this.rootElementName = name;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public BeanXMLReader(File file) {
        this.setFile(file);
    }

    public BeanXMLReader() {
    }

    @Override
    public String toXml() throws Exception {
        return this.createDoc(new ArrayList()).asXML();
    }

    @Override
    public <T> List<T> read() throws Exception {
        ArrayList tList = new ArrayList();
        this.createDoc(tList);
        return tList;
    }

    private <T> Document createDoc(List<T> tList) throws DocumentException, Exception {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(this.file);
        String sub = this.beanName == null || this.beanName.trim().length() == 0 ? "bean" : this.beanName;
        if (this.rootElementName == null || this.rootElementName.trim().length() == 0) {
            this.rootElementName = "beans";
        }
        List list = doc.selectNodes("//" + this.rootElementName + "/" + sub);
        for (Element bean : list) {
            T t = this.readRecursion(bean);
            tList.add(t);
        }
        return doc;
    }

    @Override
    public <T> T readOne() throws Exception {
        T t = null;
        List<T> list = this.read();
        if (list != null) {
            t = list.get(0);
        }
        return t;
    }

    private <T> T readRecursion(Element bean) throws Exception {
        Field[] fields;
        Class<?> clazz = this.classes.get(bean.getName());
        Object o = clazz.newInstance();
        ReflectUtil ru = new ReflectUtil(o);
        Field[] fieldArray = fields = ru.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Skip skip;
            Field f = fieldArray[n2];
            String n3 = f.getName();
            Method m = ru.getSetter(n3);
            if (m != null && (skip = f.getAnnotation(Skip.class)) == null) {
                AttrTag attrTag = f.getAnnotation(AttrTag.class);
                Writeonly writeonly = f.getAnnotation(Writeonly.class);
                if (writeonly == null) {
                    ArrayList<Object> list;
                    List eList;
                    Attribute a;
                    if (attrTag != null) {
                        if ("clazz".equals(n3)) {
                            n3 = "class";
                        }
                        if ((a = bean.attribute(n3)) != null) {
                            m.invoke(o, a.getData());
                        }
                    } else if (ClassUtil.isPojo(f.getType())) {
                        Element el = bean.element(n3);
                        if (el != null) {
                            String cls = this.classes.get(el.getName()).getName();
                            Object object = Thread.currentThread().getContextClassLoader().loadClass(cls).newInstance();
                            object = this.readRecursion(el);
                            m.invoke(o, object);
                        }
                    } else if (ClassUtil.isListClass(f)) {
                        eList = bean.elements(n3);
                        if (eList != null) {
                            list = new ArrayList<Object>();
                            for (Element e : eList) {
                                list.add(this.readRecursion(e));
                            }
                            m.invoke(o, list);
                        }
                    } else if (ClassUtil.isListString(f)) {
                        eList = bean.elements(n3);
                        if (eList != null) {
                            list = new ArrayList();
                            for (Element e : eList) {
                                list.add(e.getText());
                            }
                            m.invoke(o, list);
                        }
                    } else {
                        if ("clazz".equals(n3)) {
                            n3 = "class";
                        }
                        if ((a = bean.element(n3)) != null) {
                            m.invoke(o, String.valueOf(a.getData()));
                        }
                    }
                }
            }
            ++n2;
        }
        return (T)o;
    }
}

