/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eweb4j.util.xml.Tags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attrs {
    private String xml = null;
    private Collection<String> currentTag = new HashSet<String>();

    public static void main(String[] args) {
        String xml = "<div style='width:250; height:auto;'>This is div.<img src='http://www.baidu.com/logo.gif' alt='This is img' /></div><p style='padding:5px;'>This is p.<ul><li>This is li.<a href='http://www.baidu.com'>This is link.</a></li></ul></p>";
        String rs = Attrs.me().xml(xml).rm().ok();
        System.out.println("<div>This is div.<img /></div><p>This is p.<ul><li>This is li.<a>This is link.</a></li></ul></p>".equals(rs));
        String rs2 = Attrs.me().xml(xml).rm("style", "alt").Tags().ok();
        System.out.println("<div>This is div.<img src='http://www.baidu.com/logo.gif' /></div><p>This is p.<ul><li>This is li.<a href='http://www.baidu.com'>This is link.</a></li></ul></p>".equals(rs2));
        String rs3 = Attrs.me().xml(xml).tag("img").rm("src", "alt").tag("div", "p").rm("style").ok();
        System.out.println("<div>This is div.<img /></div><p>This is p.<ul><li>This is li.<a href='http://www.baidu.com'>This is link.</a></li></ul></p>".equals(rs3));
    }

    public static Attrs me() {
        return new Attrs();
    }

    public Attrs xml(String xml) {
        this.xml = xml;
        return this;
    }

    public Tags Tags() {
        return Tags.me().xml(this.xml);
    }

    public Attrs rm() {
        this.xml = Attrs.removeXmlTagAttr(this.xml, "", null);
        return this;
    }

    public Attrs tag(String tag) {
        this.currentTag.add(tag);
        return this;
    }

    public Attrs tag(String ... tag) {
        this.currentTag.addAll(Arrays.asList(tag));
        return this;
    }

    public Attrs rm(String attr) {
        this.xml = Attrs.removeXmlTagAttr(this.xml, this.currentTag, Arrays.asList(attr));
        this.currentTag.clear();
        return this;
    }

    public Attrs rm(String ... attr) {
        this.xml = Attrs.removeXmlTagAttr(this.xml, this.currentTag, Arrays.asList(attr));
        this.currentTag.clear();
        return this;
    }

    public String ok() {
        return this.xml;
    }

    public static String removeXmlTagAttr(String xml, Collection<String> tags, Collection<String> attrs) {
        if (tags == null || tags.isEmpty()) {
            return Attrs.removeXmlTagAttr(xml, "", attrs);
        }
        String rs = xml;
        for (String tag : tags) {
            rs = Attrs.removeXmlTagAttr(rs, tag, attrs);
        }
        return rs;
    }

    public static String removeXmlTagAttr(String xml, String tag, Collection<String> attrs) {
        String fmt = "(?<=<%s{1,255})\\s+%s=([\"'=])[^=]*\\1";
        if (tag == null || tag.trim().length() == 0) {
            tag = ".";
        }
        if (attrs == null || attrs.size() == 0) {
            return xml.replaceAll(String.format("(?<=<%s{1,255})\\s+%s=([\"'=])[^=]*\\1", tag, "\\w+"), "");
        }
        for (String attr : attrs) {
            if (attr == null || attr.trim().length() == 0) continue;
            String regex = String.format("(?<=<%s{1,255})\\s+%s=([\"'=])[^=]*\\1", tag, attr);
            xml = xml.replaceAll(regex, "");
        }
        return xml;
    }

    public static final String regex(String tag, String attr) {
        String fmt = "(?<=<%s{1,255})\\s+%s=([\"'=])[^=]*\\1";
        String regex = String.format(fmt, tag, attr);
        return regex;
    }
}

