/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class iso8583 {
    public static HashMap<String, String> ISOSCHEMA = new HashMap();
    public static HashMap<String, String> ISOMESSAGE = new HashMap();
    public static HashMap<String, String> PARSEDISOMESSAGE = new HashMap();
    public static HashMap<Integer, ArrayList<Integer>> SUBFIELDSMAPPING = new HashMap();
    public static boolean ISSUBFIELDPARSING = false;
    public static String SUBFIELDID = "";

    public static void main(String[] args) throws Exception {
        ISOSCHEMA.put("1", "BITMAP");
        ISOSCHEMA.put("4", "NUM-2-10-0_0");
        ISOSCHEMA.put("9", "NUMERIC-0-8-0_0");
        ISOSCHEMA.put("18", "FCHAR-10-10-0_0");
        ISOSCHEMA.put("52", "CHAR-2-64-0_0");
        ISOSCHEMA.put("57", "CHAR-2-50-0_0");
        ISOSCHEMA.put("58", "CHAR-2-99-0_0");
        ISOSCHEMA.put("65", "NUMERIC-1-1-0_0");
        ISOSCHEMA.put("100", "NUM-2-8-0_0");
        ISOSCHEMA.put("101", "CHAR-2-99-0_0");
        ISOSCHEMA.put("114", "CHAR-4-9999-1_1");
        ISOSCHEMA.put("114.1", "BITMAP");
        ISOSCHEMA.put("114.7", "CHAR-2-99-0_0");
        ISOSCHEMA.put("114.10", "NUM-2-5-0_0");
        ISOSCHEMA.put("114.23", "CHAR-2-20-0_0");
        ISOSCHEMA.put("114.24", "CHAR-2-20-0_0");
        ISOSCHEMA.put("114.65", "NUMERIC-0-1-0_0");
        ISOSCHEMA.put("114.117", "CHAR-2-99-0_0");
        ISOSCHEMA.put("114.150", "CHAR-2-99-0_0");
        ISOSCHEMA.put("120", "CHAR-4-9999-1_1");
        ISOSCHEMA.put("120.1", "BITMAP");
        ISOSCHEMA.put("120.64", "CHAR-2-99-0_0");
        ISOSCHEMA.put("120.120", "CHAR-2-99-0_0");
        ISOSCHEMA.put("130", "CHAR-2-90-0_0");
        HashMap<String, String> isofields = new HashMap<String, String>();
        isofields.put("4", "10");
        isofields.put("9", "99999999");
        isofields.put("18", "V");
        isofields.put("100", "3");
        isofields.put("101", "Cuelogic Technologies, India");
        isofields.put("130", "California");
        isofields.put("114.10", "99");
        isofields.put("114.117", "Steve Jobs");
        isofields.put("114.150", "Shravya Vikrant Labde");
        isofields.put("120.64", "Vikrant Labde is building ISO8583 message library for Sub Fields");
        isofields.put("120.120", "Here parsing one more subfield");
        String isoMessage = iso8583.packIsoMsg("1001", isofields);
        System.out.println("Packed iso8583 Message: " + isoMessage + "\n");
        iso8583.unpackIsoMsg(isoMessage);
        System.out.println("Unpacked iso8583 Message" + PARSEDISOMESSAGE);
    }

    public static String packIsoMsg(String MTI, HashMap<String, String> isofields) throws Exception {
        Set<Map.Entry<String, String>> set = isofields.entrySet();
        Iterator<Map.Entry<String, String>> i = set.iterator();
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, ArrayList<Integer>> subFiledBitMapHolder = new HashMap<String, ArrayList<Integer>>();
        ISOMESSAGE.put("MTI", MTI);
        while (i.hasNext()) {
            Map.Entry<String, String> me = i.next();
            String fields = me.getKey().toString();
            keys.add(fields);
            String dataType = null;
            String fieldLenType = null;
            String fieldMaxLen = null;
            String subfieldIndicator = null;
            Object hasSubfield = null;
            String hasSubfieldBitmap = null;
            String[] breakFieldForSubField = null;
            String baseField = null;
            Integer subField = null;
            try {
                breakFieldForSubField = fields.split("[.]");
                baseField = breakFieldForSubField[0].toString();
                subField = Integer.parseInt(breakFieldForSubField[1]);
                try {
                    subFiledBitMapHolder.get(baseField).add(subField);
                }
                catch (Exception e) {
                    ArrayList<Integer> arrSubFields = new ArrayList<Integer>();
                    arrSubFields.add(subField);
                    subFiledBitMapHolder.put(baseField, arrSubFields);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            String schema = ISOSCHEMA.get(fields);
            String[] arrSchema = schema.split("-");
            dataType = arrSchema[0];
            fieldLenType = arrSchema[1];
            fieldMaxLen = arrSchema[2];
            subfieldIndicator = arrSchema[3];
            String[] arrSubField = subfieldIndicator.split("_");
            hasSubfieldBitmap = arrSubField[1];
            if (dataType.equalsIgnoreCase("NUM") && fieldLenType.equalsIgnoreCase("1")) {
                throw new IOException("Field:" + fields + " has data type NUM is having field-size = 1 in ISOSCHEMA. Try assign NUMERIC data type");
            }
            String fieldVlaue = isofields.get(fields);
            Integer fieldLength = fieldVlaue.length();
            String strfieldLength = fieldLength.toString();
            if (dataType.equalsIgnoreCase("NUMERIC")) {
                if (Integer.parseInt(fieldMaxLen) >= fieldLength) {
                    String newFieldValue = "";
                    newFieldValue = fieldVlaue.equals("") ? String.format("%0" + fieldMaxLen + "d", 0) : (fieldLength == Integer.parseInt(fieldMaxLen) ? fieldVlaue : String.format("%0" + fieldMaxLen + "d", Long.parseLong(fieldVlaue)));
                    ISOMESSAGE.put(fields, newFieldValue);
                    continue;
                }
                throw new IOException("Field:" + fields + " Has bigger value. Its set " + fieldMaxLen + " in ISOSCHEMA and you have entered" + fieldLength);
            }
            if (dataType.equalsIgnoreCase("CHAR") || dataType.equalsIgnoreCase("NUM")) {
                if (Integer.parseInt(fieldMaxLen) >= fieldLength) {
                    String newFieldLen = String.format("%0" + fieldLenType + "d", Long.parseLong(strfieldLength));
                    ISOMESSAGE.put(fields.toString(), String.valueOf(newFieldLen) + fieldVlaue);
                    continue;
                }
                throw new IOException("Field:" + fields + " Has bigger value. Its set " + fieldMaxLen + " in ISOSCHEMA and you have entered" + fieldLength);
            }
            if (dataType.equalsIgnoreCase("FCHAR")) {
                if (Integer.parseInt(fieldMaxLen) >= fieldLength) {
                    String newFieldValue = String.format("%-" + fieldMaxLen + "s", fieldVlaue);
                    ISOMESSAGE.put(fields.toString(), newFieldValue);
                    continue;
                }
                throw new IOException("Field:" + fields + " Has bigger value. Its set " + fieldMaxLen + " in ISOSCHEMA and you have entered" + fieldLength);
            }
            if (dataType.equalsIgnoreCase("PCHAR")) {
                if (Integer.parseInt(fieldMaxLen) >= fieldLength) {
                    String newFieldValue = String.format("%" + fieldMaxLen + "s", fieldVlaue);
                    newFieldValue = newFieldValue.replaceAll(" ", "0");
                    ISOMESSAGE.put(fields.toString(), newFieldValue);
                    continue;
                }
                throw new IOException("Field:" + fields + " Has bigger value. Its set " + fieldMaxLen + " in ISOSCHEMA and you have entered" + fieldLength);
            }
            if (!dataType.equalsIgnoreCase("BINARY")) continue;
            if (Integer.parseInt(fieldMaxLen) >= fieldLength) {
                String fPa;
                int iRe;
                int bytes = (fieldLength + 1) / 2;
                StringBuffer sb = new StringBuffer();
                if (fieldLength % 2 == 0) {
                    iRe = 0;
                    while (iRe < fieldLength) {
                        fPa = fieldVlaue.substring(iRe, iRe + 2);
                        sb.append(iso8583.CtoX(fPa));
                        iRe += 2;
                    }
                } else {
                    fPa = "";
                    fPa = String.valueOf(fPa) + fieldVlaue.charAt(0);
                    sb.append(iso8583.CtoX(fPa));
                    iRe = 1;
                    while (iRe < fieldLength) {
                        fPa = fieldVlaue.substring(iRe, iRe + 2);
                        sb.append(iso8583.CtoX(fPa));
                        iRe += 2;
                    }
                }
                ISOMESSAGE.put(fields.toString(), sb.substring(0, sb.length()));
                continue;
            }
            throw new IOException("Field:" + fields + " Has bigger value. Its set " + fieldMaxLen + " in ISOSCHEMA and you have entered" + fieldLength);
        }
        ArrayList<Integer> finalFields = new ArrayList();
        finalFields = iso8583.processBitmap(iso8583.parseFields(keys));
        iso8583.processSubFieldBitmap(subFiledBitMapHolder);
        return iso8583.buildISOMessage(finalFields);
    }

    public static String buildISOMessage(ArrayList<Integer> finalFields) throws Exception {
        String isoMessage = ISOMESSAGE.get("MTI");
        isoMessage = String.valueOf(isoMessage) + ISOMESSAGE.get("1");
        Iterator<Integer> j = finalFields.iterator();
        while (j.hasNext()) {
            String dataElement = ((Object)j.next()).toString();
            String schema = ISOSCHEMA.get(dataElement);
            try {
                String[] arrSchema = schema.split("-");
                String fieldLenType = arrSchema[1];
                String subfieldIndicator = arrSchema[3];
                String[] arrSubField = subfieldIndicator.split("_");
                String hasSubfield = arrSubField[0];
                if (hasSubfield.equalsIgnoreCase("1")) {
                    ArrayList<Object> subFields = new ArrayList();
                    subFields = SUBFIELDSMAPPING.get(Integer.parseInt(dataElement));
                    Iterator<Object> i = subFields.iterator();
                    String isoSubMessage = "";
                    if (!subFields.contains(1)) {
                        isoSubMessage = String.valueOf(isoSubMessage) + ISOMESSAGE.get(String.valueOf(dataElement) + ".1");
                    }
                    while (i.hasNext()) {
                        String subDataElement = i.next().toString();
                        String mainDataElement = String.valueOf(dataElement) + "." + subDataElement;
                        isoSubMessage = String.valueOf(isoSubMessage) + ISOMESSAGE.get(mainDataElement);
                    }
                    String subMessageLen = String.format("%0" + fieldLenType + "d", isoSubMessage.length());
                    isoMessage = String.valueOf(isoMessage) + subMessageLen + isoSubMessage;
                    continue;
                }
                isoMessage = String.valueOf(isoMessage) + ISOMESSAGE.get(dataElement);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isoMessage;
    }

    public static ArrayList<Integer> parseFields(ArrayList<String> fields) throws Exception {
        ArrayList<Integer> newFiledMap = new ArrayList<Integer>();
        Iterator<String> j = fields.iterator();
        while (j.hasNext()) {
            try {
                String[] breakFieldForSubField = j.next().toString().split("[.]");
                Integer baseField = Integer.parseInt(breakFieldForSubField[0].toString());
                if (newFiledMap.contains(baseField)) continue;
                newFiledMap.add(baseField);
            }
            catch (Exception e) {
                Integer keys = Integer.parseInt(j.next().toString());
                newFiledMap.add(keys);
            }
        }
        Collections.sort(newFiledMap);
        return newFiledMap;
    }

    public static ArrayList<Integer> processBitmap(ArrayList<Integer> fields) throws Exception {
        char[] bitMap;
        String bitmapType = "primary";
        Integer DE = fields.get(fields.size() - 1);
        if (DE > 65 && DE <= 128) {
            fields.add(1);
            bitmapType = "secondary";
            bitMap = new char[16];
        } else if (DE > 128) {
            fields.add(1);
            fields.add(65);
            ISOMESSAGE.put("65", "1");
            bitmapType = "tertiary";
            bitMap = new char[24];
        } else {
            bitmapType = "primary";
            bitMap = new char[8];
        }
        Collections.sort(fields);
        iso8583.CalcBitMap(bitMap, fields);
        ISOMESSAGE.put("1", String.valueOf(bitMap, 0, bitMap.length));
        return fields;
    }

    public static void processSubFieldBitmap(HashMap<String, ArrayList<Integer>> subFieldMap) throws Exception {
        Set<Map.Entry<String, ArrayList<Integer>>> set = subFieldMap.entrySet();
        for (Map.Entry<String, ArrayList<Integer>> me : set) {
            char[] bitMap;
            ArrayList<Object> fields = new ArrayList();
            fields = me.getValue();
            String subFieldId = me.getKey().toString();
            Collections.sort(fields);
            String bitmapType = "primary";
            Integer DE = (Integer)fields.get(fields.size() - 1);
            if (DE > 65 && DE <= 128) {
                fields.add(1);
                bitmapType = "secondary";
                bitMap = new char[16];
            } else if (DE > 128) {
                fields.add(1);
                fields.add(65);
                ISOMESSAGE.put(String.valueOf(subFieldId) + ".65", "1");
                bitmapType = "tertiary";
                bitMap = new char[24];
            } else {
                bitmapType = "primary";
                bitMap = new char[8];
            }
            Collections.sort(fields);
            SUBFIELDSMAPPING.put(Integer.parseInt(subFieldId), fields);
            iso8583.CalcBitMap(bitMap, fields);
            ISOMESSAGE.put(String.valueOf(subFieldId) + ".1", String.valueOf(bitMap, 0, bitMap.length));
        }
    }

    public static void unpackIsoMsg(String isoMessage) throws Exception {
        String primaryBitMap;
        String overallBitmap = null;
        String messageAfterBitMap = null;
        if (!ISSUBFIELDPARSING) {
            PARSEDISOMESSAGE.put("MTI", isoMessage.substring(0, 4));
        }
        String priMaryHexBitMap = "";
        priMaryHexBitMap = !ISSUBFIELDPARSING ? isoMessage.substring(4, 12) : isoMessage.substring(0, 8);
        overallBitmap = primaryBitMap = iso8583.GetBitMap(priMaryHexBitMap, 1);
        Integer firstBit = Integer.parseInt(primaryBitMap.substring(0, 1));
        String secondaryHexBitmap = null;
        String secondaryBitMap = null;
        String tertiaryHexBitmap = null;
        String tertiaryBitMap = null;
        int bitmaplength = 64;
        if (firstBit > 0) {
            bitmaplength = 128;
            secondaryHexBitmap = !ISSUBFIELDPARSING ? isoMessage.substring(12, 20) : isoMessage.substring(8, 16);
            secondaryBitMap = iso8583.GetBitMap(secondaryHexBitmap, 1);
            overallBitmap = String.valueOf(overallBitmap) + secondaryBitMap;
            Integer firstBitOfSecBitmap = Integer.parseInt(secondaryBitMap.substring(0, 1));
            if (firstBitOfSecBitmap > 0) {
                bitmaplength = 192;
                tertiaryHexBitmap = !ISSUBFIELDPARSING ? isoMessage.substring(20, 28) : isoMessage.substring(16, 24);
                tertiaryBitMap = iso8583.GetBitMap(tertiaryHexBitmap, 1);
                overallBitmap = String.valueOf(overallBitmap) + tertiaryBitMap;
                messageAfterBitMap = !ISSUBFIELDPARSING ? isoMessage.substring(28) : isoMessage.substring(24);
            } else {
                messageAfterBitMap = !ISSUBFIELDPARSING ? isoMessage.substring(20) : isoMessage.substring(16);
            }
        } else {
            messageAfterBitMap = !ISSUBFIELDPARSING ? isoMessage.substring(12) : isoMessage.substring(8);
        }
        ArrayList<Integer> debugList = new ArrayList<Integer>();
        String remainingMessage = null;
        int i = 0;
        while (i < bitmaplength) {
            char bit = overallBitmap.charAt(i);
            if (bit == '1') {
                debugList.add(i + 1);
                Integer field = i + 1;
                String dataType = null;
                String fieldLenType = null;
                String fieldMaxLen = null;
                String subfieldIndicator = null;
                String hasSubfield = null;
                String hasSubfieldBitmap = null;
                if (field > 1) {
                    String fieldValue;
                    String schema = null;
                    try {
                        schema = ISOSCHEMA.get(String.valueOf(SUBFIELDID) + field.toString());
                    }
                    catch (Exception e) {
                        throw new IOException(field + " has problem with schema.");
                    }
                    try {
                        String[] arrSchema = schema.split("-");
                        dataType = arrSchema[0];
                        fieldLenType = arrSchema[1];
                        fieldMaxLen = arrSchema[2];
                        subfieldIndicator = arrSchema[3];
                        String[] arrSubField = subfieldIndicator.split("_");
                        hasSubfield = arrSubField[0];
                        hasSubfieldBitmap = arrSubField[1];
                    }
                    catch (Exception e) {
                        throw new IOException(field + " has problem with schema.");
                    }
                    if (dataType.equalsIgnoreCase("NUMERIC")) {
                        if (remainingMessage == null) {
                            fieldValue = messageAfterBitMap.substring(0, Integer.parseInt(fieldMaxLen));
                            if (fieldValue == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            if (hasSubfield.equalsIgnoreCase("1")) {
                                ISSUBFIELDPARSING = true;
                                SUBFIELDID = field + ".";
                                iso8583.unpackIsoMsg(fieldValue);
                            } else {
                                PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue);
                            }
                            remainingMessage = messageAfterBitMap.substring(Integer.parseInt(fieldMaxLen));
                        } else {
                            fieldValue = remainingMessage.substring(0, Integer.parseInt(fieldMaxLen));
                            if (fieldValue == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            if (hasSubfield.equalsIgnoreCase("1")) {
                                ISSUBFIELDPARSING = true;
                                SUBFIELDID = field + ".";
                                iso8583.unpackIsoMsg(fieldValue);
                            } else {
                                PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue);
                            }
                            remainingMessage = remainingMessage.substring(Integer.parseInt(fieldMaxLen));
                        }
                    } else if (dataType.equalsIgnoreCase("FCHAR")) {
                        if (remainingMessage == null) {
                            fieldValue = messageAfterBitMap.substring(0, Integer.parseInt(fieldMaxLen)).trim();
                            if (fieldValue == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            if (hasSubfield.equalsIgnoreCase("1")) {
                                ISSUBFIELDPARSING = true;
                                SUBFIELDID = field + ".";
                                iso8583.unpackIsoMsg(fieldValue);
                            } else {
                                PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue);
                            }
                            remainingMessage = messageAfterBitMap.substring(Integer.parseInt(fieldMaxLen));
                        } else {
                            fieldValue = remainingMessage.substring(0, Integer.parseInt(fieldMaxLen)).trim();
                            if (fieldValue == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            if (hasSubfield.equalsIgnoreCase("1")) {
                                ISSUBFIELDPARSING = true;
                                SUBFIELDID = field + ".";
                                iso8583.unpackIsoMsg(fieldValue);
                            } else {
                                PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue);
                            }
                            remainingMessage = remainingMessage.substring(Integer.parseInt(fieldMaxLen));
                        }
                    } else if (dataType.equalsIgnoreCase("PCHAR")) {
                        if (remainingMessage == null) {
                            fieldValue = messageAfterBitMap.substring(0, Integer.parseInt(fieldMaxLen)).replaceFirst("^0+(?!$)", "");
                            if (fieldValue == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            if (hasSubfield.equalsIgnoreCase("1")) {
                                ISSUBFIELDPARSING = true;
                                SUBFIELDID = field + ".";
                                iso8583.unpackIsoMsg(fieldValue);
                            } else {
                                PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue);
                            }
                            remainingMessage = messageAfterBitMap.substring(Integer.parseInt(fieldMaxLen));
                        } else {
                            fieldValue = remainingMessage.substring(0, Integer.parseInt(fieldMaxLen)).replaceFirst("^0+(?!$)", "");
                            if (fieldValue == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            if (hasSubfield.equalsIgnoreCase("1")) {
                                ISSUBFIELDPARSING = true;
                                SUBFIELDID = field + ".";
                                iso8583.unpackIsoMsg(fieldValue);
                            } else {
                                PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue);
                            }
                            remainingMessage = remainingMessage.substring(Integer.parseInt(fieldMaxLen));
                        }
                    } else if (dataType.equalsIgnoreCase("BINARY")) {
                        String originalValue;
                        char value;
                        int x;
                        String originalMsg;
                        if (remainingMessage == null) {
                            fieldValue = messageAfterBitMap.substring(0, Integer.parseInt(fieldMaxLen) / 2);
                            System.out.println(fieldValue);
                            if (fieldValue == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            originalMsg = "";
                            x = 0;
                            while (x < fieldValue.length()) {
                                value = fieldValue.charAt(x);
                                originalValue = Integer.toHexString(value);
                                originalMsg = String.valueOf(originalMsg) + originalValue;
                                ++x;
                            }
                            fieldValue = Integer.toString(Integer.parseInt(originalMsg, 16));
                            PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue);
                            remainingMessage = messageAfterBitMap.substring(Integer.parseInt(fieldMaxLen) / 2);
                        } else {
                            fieldValue = remainingMessage.substring(0, Integer.parseInt(fieldMaxLen) / 2);
                            if (fieldValue == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            originalMsg = "";
                            x = 0;
                            while (x < fieldValue.length()) {
                                value = fieldValue.charAt(x);
                                originalValue = Integer.toHexString(value);
                                originalMsg = String.valueOf(originalMsg) + originalValue;
                                ++x;
                            }
                            fieldValue = Integer.toString(Integer.parseInt(originalMsg, 16));
                            PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue);
                            remainingMessage = remainingMessage.substring(Integer.parseInt(fieldMaxLen) / 2);
                        }
                    } else if (dataType.equalsIgnoreCase("CHAR") || dataType.equalsIgnoreCase("NUM")) {
                        String fieldValue2;
                        String fieldlength;
                        if (remainingMessage == null) {
                            fieldlength = messageAfterBitMap.substring(0, Integer.parseInt(fieldLenType));
                            remainingMessage = messageAfterBitMap.substring(Integer.parseInt(fieldLenType));
                            fieldValue2 = remainingMessage.substring(0, Integer.parseInt(fieldlength));
                            if (fieldValue2 == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            if (hasSubfield.equalsIgnoreCase("1")) {
                                ISSUBFIELDPARSING = true;
                                SUBFIELDID = field + ".";
                                iso8583.unpackIsoMsg(fieldValue2);
                            } else {
                                PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue2);
                            }
                            remainingMessage = remainingMessage.substring(Integer.parseInt(fieldlength));
                        } else {
                            fieldlength = remainingMessage.substring(0, Integer.parseInt(fieldLenType));
                            fieldValue2 = (remainingMessage = remainingMessage.substring(Integer.parseInt(fieldLenType))).substring(0, Integer.parseInt(fieldlength));
                            if (fieldValue2 == null) {
                                throw new IOException(field + " Has null or inappropriate value");
                            }
                            if (hasSubfield.equalsIgnoreCase("1")) {
                                ISSUBFIELDPARSING = true;
                                SUBFIELDID = field + ".";
                                iso8583.unpackIsoMsg(fieldValue2);
                            } else {
                                PARSEDISOMESSAGE.put(String.valueOf(SUBFIELDID) + field.toString(), fieldValue2);
                            }
                            remainingMessage = remainingMessage.substring(Integer.parseInt(fieldlength));
                        }
                    }
                }
            }
            ++i;
        }
        ISSUBFIELDPARSING = false;
        SUBFIELDID = "";
    }

    public static String CalcBitMap(char[] bitMap, ArrayList<Integer> list) throws Exception {
        int i = 0;
        while (i < list.size()) {
            int iPos = list.get(i) / 8;
            int iPosIn = list.get(i) - iPos * 8;
            if (iPosIn == 0) {
                --iPos;
                iPosIn = 8;
            }
            if (65 <= list.get(i) && list.get(i) < 128) {
                bitMap[0] = (char)(bitMap[0] | 0x80);
            }
            if (128 <= list.get(i) && list.get(i) < 192) {
                bitMap[8] = (char)(bitMap[8] | 0x80);
            }
            int n = iPos;
            bitMap[n] = (char)(bitMap[n] | 1 << 8 - iPosIn);
            ++i;
        }
        return "OK";
    }

    public static String GetBitMap(String bin, int nouse) throws Exception {
        int iCo = 0;
        StringBuffer binRes = new StringBuffer(64);
        iCo = 0;
        while (iCo < 8) {
            if ((bin.charAt(iCo) & 0x80) > 0) {
                binRes.append('1');
            } else {
                binRes.append('0');
            }
            if ((bin.charAt(iCo) & 0x40) > 0) {
                binRes.append('1');
            } else {
                binRes.append('0');
            }
            if ((bin.charAt(iCo) & 0x20) > 0) {
                binRes.append('1');
            } else {
                binRes.append('0');
            }
            if ((bin.charAt(iCo) & 0x10) > 0) {
                binRes.append('1');
            } else {
                binRes.append('0');
            }
            if ((bin.charAt(iCo) & 8) > 0) {
                binRes.append('1');
            } else {
                binRes.append('0');
            }
            if ((bin.charAt(iCo) & 4) > 0) {
                binRes.append('1');
            } else {
                binRes.append('0');
            }
            if ((bin.charAt(iCo) & 2) > 0) {
                binRes.append('1');
            } else {
                binRes.append('0');
            }
            if ((bin.charAt(iCo) & '\u0001') > 0) {
                binRes.append('1');
            } else {
                binRes.append('0');
            }
            ++iCo;
        }
        return binRes.toString();
    }

    public static String replaceCharAt(String s, int pos, char c) throws Exception {
        return String.valueOf(s.substring(0, pos)) + c + s.substring(pos + 1);
    }

    public static char CtoX(String x) {
        int r = 0;
        r = Integer.parseInt(x, 16);
        return (char)r;
    }

    public static String networkTransport(String isoMessage) throws UnknownHostException, IOException {
        Socket connection = new Socket("127.1.1.1", 1223);
        BufferedOutputStream bos = new BufferedOutputStream(connection.getOutputStream());
        OutputStreamWriter osw = new OutputStreamWriter(bos);
        osw.write(String.valueOf(isoMessage) + "\n");
        osw.flush();
        byte[] arrOutut = new byte[4096];
        int count = connection.getInputStream().read(arrOutut, 0, 4096);
        String clientRequest = "";
        int outputCount = 0;
        while (outputCount < count) {
            char response = (char)arrOutut[outputCount];
            clientRequest = String.valueOf(clientRequest) + response;
            ++outputCount;
        }
        connection.close();
        return clientRequest;
    }
}

