/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eweb4j.util.FileUtil;
import org.eweb4j.util.PicsModel;

public class PicUtil {
    public static void main(String[] args) throws Exception {
        String url = "http://www.featcher.sg/deal_images/wall street cafe/web3.jpg";
        PicsModel model = PicUtil.getAttrs(url);
        BufferedImage img = FileUtil.getBufferedImage(url, 3, 1000L);
        System.out.println(img.getWidth());
        System.out.println("picextendname is:" + model.getExtName());
        System.out.println("picwidth is:" + model.getWidth());
        System.out.println("picheight is:" + model.getHeight());
        System.out.println("piccolor:" + model.getColor());
        System.out.println("picsize:" + model.getSize());
    }

    public static PicsModel getAttrs(String picpath) throws Exception {
        PicsModel model = null;
        String picextendname = null;
        byte[] content = PicUtil.readFromFile(picpath);
        int k = content.length;
        if (k == 0) {
            return model;
        }
        Integer kk = null;
        String picsize = null;
        if (k >= 1024) {
            k = k / 1024 + 1;
            kk = new Integer(k);
            picsize = String.valueOf(kk.toString()) + "K";
        } else if (k > 0) {
            kk = new Integer(k);
            picsize = kk.toString();
        }
        model = new PicsModel();
        model.setSize(picsize);
        picextendname = PicUtil.getFileExtendName(content);
        if (picextendname == null || picextendname.trim().length() == 0) {
            return model;
        }
        int picwidth = 0;
        int picheight = 0;
        int color = 0;
        String piccolor = null;
        if (picextendname.equals("GIF")) {
            picwidth = PicUtil.getFileAttribute(content, 7, 2, picextendname);
            picheight = PicUtil.getFileAttribute(content, 9, 2, picextendname);
            color = PicUtil.getFileAttribute(content, 10, 1, picextendname);
            color = color % 8 + 1;
            piccolor = PicUtil.getPicColor(color);
        }
        if (picextendname.equals("JPG")) {
            picwidth = PicUtil.getFileAttribute(content, 166, 2, picextendname);
            picheight = PicUtil.getFileAttribute(content, 164, 2, picextendname);
            color = PicUtil.getFileAttribute(content, 167, 1, picextendname);
            if (picwidth == 0 || picheight == 0 || (color *= 8) > 3) {
                picwidth = PicUtil.getFileAttribute(content, 197, 2, picextendname);
                picheight = PicUtil.getFileAttribute(content, 195, 2, picextendname);
                color = PicUtil.getFileAttribute(content, 198, 1, picextendname);
                color *= 8;
            }
            piccolor = PicUtil.getPicColor(color);
        }
        if (picextendname.equals("BMP")) {
            picwidth = PicUtil.getFileAttribute(content, 19, 2, picextendname);
            picheight = PicUtil.getFileAttribute(content, 23, 2, picextendname);
            color = PicUtil.getFileAttribute(content, 28, 1, picextendname);
            piccolor = PicUtil.getPicColor(color);
        }
        if (picextendname.equals("PNG")) {
            picwidth = PicUtil.getFileAttribute(content, 19, 2, picextendname);
            picheight = PicUtil.getFileAttribute(content, 23, 2, picextendname);
            piccolor = "16M";
        }
        model.setExtName(picextendname);
        model.setWidth(picwidth);
        model.setHeight(picheight);
        model.setColor(piccolor);
        return model;
    }

    private static byte[] readFromFile(String fileName) throws IOException {
        InputStream is = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                URL url = new URL(fileName.replace(" ", "%20"));
                is = url.openStream();
            } else {
                is = new FileInputStream(fileName);
            }
            byte[] buf = new byte[is.available()];
            is.read(buf);
            byte[] byArray = buf;
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static String getFileExtendName(byte[] byte1) {
        String strFileExtendName = null;
        if (byte1[0] == 71 && byte1[1] == 73 && byte1[2] == 70 && byte1[3] == 56 && (byte1[4] == 55 || byte1[4] == 57) && byte1[5] == 97) {
            strFileExtendName = "GIF";
        }
        if (byte1[6] == 74 && byte1[7] == 70 && byte1[8] == 73 && byte1[9] == 70) {
            strFileExtendName = "JPG";
        }
        if (byte1[0] == 66 && byte1[1] == 77) {
            strFileExtendName = "BMP";
        }
        if (byte1[1] == 80 && byte1[2] == 78 && byte1[3] == 71) {
            strFileExtendName = "PNG";
        }
        return strFileExtendName;
    }

    private static int getFileAttribute(byte[] byte2, int n, int m, String fileextendname) {
        int j = 0;
        int FileAttributeValue = 0;
        String str = "";
        String str1 = "";
        int k = 0;
        while (k < m) {
            if (byte2[n - k] < 0) {
                j = byte2[n - k];
                j += 256;
            } else {
                j = byte2[n - k];
            }
            str1 = Integer.toHexString(j);
            if (str1.length() < 2) {
                str1 = "0" + str1;
            }
            str = fileextendname.equalsIgnoreCase("JPG") || fileextendname.equalsIgnoreCase("PNG") ? String.valueOf(str1) + str : String.valueOf(str) + str1;
            ++k;
        }
        FileAttributeValue = PicUtil.HexToDec(str);
        return FileAttributeValue;
    }

    private static int HexToDec(String cadhex) {
        int n = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        int decimal = 0;
        String CADHEX1 = null;
        n = cadhex.length();
        CADHEX1 = cadhex.trim().toUpperCase();
        while (i < n) {
            j = CADHEX1.charAt(i);
            if (j >= 48 && j < 65) {
                j -= 48;
            }
            if (j >= 65) {
                j -= 55;
            }
            ++i;
            k = 1;
            int m = 0;
            while (m < n - i) {
                k *= 16;
                ++m;
            }
            decimal = j * k + decimal;
        }
        return decimal;
    }

    private static String getPicColor(int color) {
        int k = 1;
        String piccolor = null;
        int m = 0;
        while (m < color) {
            k *= 2;
            ++m;
        }
        Integer kk = null;
        if (k >= 0x100000) {
            kk = new Integer(k /= 0x100000);
            piccolor = String.valueOf(kk.toString()) + "M";
        } else if (k >= 1024) {
            kk = new Integer(k /= 1024);
            piccolor = String.valueOf(kk.toString()) + "K";
        } else if (k > 0) {
            kk = new Integer(k);
            piccolor = kk.toString();
        }
        return piccolor;
    }
}

