/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eweb4j.cache.ORMConfigBeanCache;
import org.eweb4j.cache.Props;
import org.eweb4j.orm.config.bean.ORMConfigBean;
import org.eweb4j.orm.config.bean.Property;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtil {
    public static void main(String[] args) {
        String[] ss = "+1d +16h +37m +40s".replace("+", "").split(" ");
        System.out.println(Arrays.asList(ss));
        long days = CommonUtil.toSeconds(ss[0]).longValue();
        long hours = CommonUtil.toSeconds(ss[1]).longValue();
        long mins = CommonUtil.toSeconds(ss[2]).longValue();
        long secs = CommonUtil.toSeconds(ss[3]).longValue();
        long all = CommonUtil.getNow() + (days + hours + mins + secs) * 1000L;
        System.out.println(all);
        System.out.println(CommonUtil.formatTime(new Date(all)));
        System.out.println(CommonUtil.calculateTime(new Date().getTime(), all));
        System.out.println(CommonUtil.formatTime(new Date(1357660800000L)));
        String source = "2013-01-17 11:00";
        Date date = CommonUtil.parse("yyyy-MM-dd HH:mm", source);
        System.out.println(String.valueOf(date.getTime()).substring(0, 10));
        long time = System.currentTimeMillis() + CommonUtil.toSeconds("dh 7m 42s").longValue() * 1000L;
        System.out.println(time);
        System.out.println(("" + time).substring(0, 10));
        System.out.println(CommonUtil.formatTime(new Date(time)));
        String x = "x                                        Crystal Jade Kitchen and Crystal Jade Korean BBQ                    #01-01/02                    Tel: 6634 4920";
        System.out.println(Arrays.asList(x.split(" ")));
        System.out.println(CommonUtil.evalCalculateExp("*", "13.25 * 1.21").floatValue());
        String coords = "157,117, 55,407, 114,438, 138,359, 126,299, 164,232, 200,297, 157,413, 179,431, 219,388, 236,271, 193,186, 259,206, 260,337, 268,404, 336,346, 501,346, 710,369, 828,53, 595,314, 567,237, 359,213, 299,168, 255,103, 199,164, 161,115";
        String center = null;
        center = CommonUtil.getCenterCoord(coords);
        System.out.println(center);
        System.out.println(CommonUtil.resolveCoords("1,2,3,4,5,6"));
    }

    public static String appendString(Object ... objs) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            sb.append(obj);
            ++n2;
        }
        return sb.toString();
    }

    public static String resolveCoords(String _coords) {
        String[] cs = _coords.split(",");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < cs.length) {
            if ((i + 1) % 2 == 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(cs[i - 1]).append(",").append(cs[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getCenterCoord(String _coords) {
        if (_coords == null || _coords.trim().length() == 0) {
            return null;
        }
        try {
            float f;
            String coords = _coords.trim();
            String[] pts = coords.split(" ");
            int nPts = pts.length;
            float x = 0.0f;
            float y = 0.0f;
            int j = nPts - 1;
            int i = 0;
            while (i < nPts) {
                String p1 = pts[i].trim();
                if (p1.length() != 0) {
                    float p1_x = CommonUtil.toFloat(p1.split(",")[0]).floatValue();
                    float p1_y = CommonUtil.toFloat(p1.split(",")[1]).floatValue();
                    String p2 = pts[j].trim();
                    if (p2.length() != 0) {
                        float p2_x = CommonUtil.toFloat(p2.split(",")[0]).floatValue();
                        float p2_y = CommonUtil.toFloat(p2.split(",")[1]).floatValue();
                        f = p1_x * p2_y - p2_x * p1_y;
                        x += (p1_x + p2_x) * f;
                        y += (p1_y + p2_y) * f;
                    }
                }
                j = i++;
            }
            f = CommonUtil.area(pts) * 6.0f;
            return String.valueOf(x / f) + "," + y / f;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static float area(String[] pts) {
        float area = 0.0f;
        int nPts = pts.length;
        int j = nPts - 1;
        int i = 0;
        while (i < nPts) {
            String p1 = pts[i].trim();
            if (p1.length() != 0) {
                float p1_x = CommonUtil.toFloat(p1.split(",")[0]).floatValue();
                float p1_y = CommonUtil.toFloat(p1.split(",")[1]).floatValue();
                String p2 = pts[j].trim();
                if (p2.length() != 0) {
                    float p2_x = CommonUtil.toFloat(p2.split(",")[0]).floatValue();
                    float p2_y = CommonUtil.toFloat(p2.split(",")[1]).floatValue();
                    area += p1_x * p2_y;
                    area -= p1_y * p2_x;
                }
            }
            j = i++;
        }
        return area /= 2.0f;
    }

    public static String fetchUrl(String _url) {
        return CommonUtil.fetchUrl(_url, null);
    }

    public static String fetchUrl(String _url, String charset) {
        BufferedReader reader = null;
        try {
            URL url = new URL(_url);
            reader = charset == null ? new BufferedReader(new InputStreamReader(url.openStream())) : new BufferedReader(new InputStreamReader(url.openStream(), charset));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Number evalCalculateExp(String op, String exp) {
        String _op = op;
        if ("*".equals(op)) {
            _op = "\\*";
        }
        String[] s = exp.split(_op);
        double left = CommonUtil.toDouble(s[0].trim());
        double right = CommonUtil.toDouble(s[1].trim());
        return "-".equals(op) ? left - right : ("+".equals(op) ? left + right : ("*".equals(op) ? left * right : ("/".equals(op) ? Double.valueOf(left / right) : null)));
    }

    public static Number random(double min, double max) {
        return min + (max - min) * Math.random();
    }

    public static String cleanLF(String str) {
        return str.replace("\n", "");
    }

    public static Double addDouble(Object d1, Object d2) {
        return CommonUtil.toDouble(String.valueOf(d1)) + CommonUtil.toDouble(String.valueOf(d2));
    }

    public static Float addFloat(Object d1, Object d2) {
        return Float.valueOf(CommonUtil.toFloat(String.valueOf(d1)).floatValue() + CommonUtil.toFloat(String.valueOf(d2)).floatValue());
    }

    public static Integer addInteger(Object d1, Object d2) {
        return CommonUtil.toInt(String.valueOf(d1)) + CommonUtil.toInt(String.valueOf(d2));
    }

    public static Long addLong(Object d1, Object d2) {
        return CommonUtil.toLong(String.valueOf(d1)) + CommonUtil.toLong(String.valueOf(d2));
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static Integer toInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Long toLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Float toFloat(String str) {
        try {
            return Float.valueOf(Float.parseFloat(str));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Double toDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Boolean toBoolean(String str) {
        try {
            return Boolean.parseBoolean(str);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String String() {
        return CommonUtil.String("");
    }

    public static String String(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static String toXml(Node node, boolean keepHeader) throws Exception {
        DOMSource xmlSource = new DOMSource(node);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        StreamResult outputTarget = new StreamResult(writer);
        transformer.transform(xmlSource, outputTarget);
        String str = writer.getBuffer().toString();
        if (!keepHeader) {
            return str.substring(str.indexOf("?>") + 2);
        }
        return str;
    }

    public static String cleanOtherXmlTags(String html, String ... keepTags) {
        return html.replaceAll(CommonUtil.inverseXmlTagsRegex(keepTags), "");
    }

    public static String cleanXmlTags(String html, boolean isRMCnt, String ... delTags) {
        if (isRMCnt) {
            String[] stringArray = delTags;
            int n = delTags.length;
            int n2 = 0;
            while (n2 < n) {
                String delTag = stringArray[n2];
                List<String> tag = CommonUtil.findByRegex(html, CommonUtil.xmlTagsRegex(delTag));
                if (tag != null && !tag.isEmpty() && tag.size() == 2) {
                    String regex = String.valueOf(CommonUtil.resolveRegex(tag.get(0))) + ".*" + CommonUtil.resolveRegex(tag.get(1));
                    html = html.replaceAll(regex, "");
                }
                ++n2;
            }
            return html;
        }
        return html.replaceAll(CommonUtil.xmlTagsRegex(delTags), "");
    }

    public static String resolveRegex(String regex) {
        List<String> cc = Arrays.asList("\\", "^", "$", "*", "+", "?", "{", "}", "(", ")", ".", "[", "]", "|");
        for (String c : cc) {
            regex = regex.replace(c, "\\" + c);
        }
        return regex;
    }

    public static String inverseXmlTagsRegex(String ... keepTags) {
        if (keepTags == null || keepTags.length == 0) {
            return "<[!/]?\\b\\w+\\b\\s*[^>]*>";
        }
        String fmt = "\\b%s\\b";
        StringBuilder sb = new StringBuilder();
        String[] stringArray = keepTags;
        int n = keepTags.length;
        int n2 = 0;
        while (n2 < n) {
            String kt = stringArray[n2];
            if (kt != null && kt.trim().length() != 0) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(String.format(fmt, kt));
            }
            ++n2;
        }
        if (sb.length() == 0) {
            return "<[!/]?\\b\\w+\\b\\s*[^>]*>";
        }
        String pattern = "<[!/]?\\b(?!(" + sb.toString() + "))+\\b\\s*[^>]*>";
        return pattern;
    }

    public static String xmlTagsRegex(String ... tags) {
        if (tags == null || tags.length == 0) {
            return "<[!/]?\\b\\w+\\b\\s*[^>]*>";
        }
        String fmt = "\\b%s\\b";
        StringBuilder sb = new StringBuilder();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String kt = stringArray[n2];
            if (kt != null && kt.trim().length() != 0) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(String.format(fmt, kt));
            }
            ++n2;
        }
        if (sb.length() == 0) {
            return "<[!/]?\\b\\w+\\b\\s*[^>]*>";
        }
        String pattern = "<[!/]?(" + sb.toString() + ")\\s*[^>]*>";
        return pattern;
    }

    public static <T> T mappingPojo(Map<String, Object> data, Class<T> cls) throws Exception {
        if (data == null) {
            return null;
        }
        ArrayList<Map<String, Object>> _list = new ArrayList<Map<String, Object>>(1);
        _list.add(data);
        List<T> list = CommonUtil.mappingPojo(_list, cls);
        return list == null ? null : (T)list.get(0);
    }

    public static <T> List<T> mappingPojo(List<Map<String, Object>> datas, Class<T> cls) throws Exception {
        if (datas == null || datas.isEmpty()) {
            return null;
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (String col : datas.get(0).keySet()) {
            columns.add(col);
        }
        ArrayList list = new ArrayList();
        Object t = null;
        for (Map<String, Object> data : datas) {
            t = cls.newInstance();
            ReflectUtil ru = new ReflectUtil(t);
            ORMConfigBean ormBean = ORMConfigBeanCache.get(cls.getName());
            for (Property p : ormBean.getProperty()) {
                Object value;
                Method m;
                String type = p.getType();
                if (type == null) continue;
                boolean flag = false;
                for (String col : columns) {
                    if (!col.equalsIgnoreCase(p.getColumn())) continue;
                    flag = true;
                }
                if (!flag || (m = ru.getSetter(p.getName())) == null || (value = data.get(p.getColumn())) == null) continue;
                String v = String.valueOf(value);
                if (v == null) {
                    v = "";
                }
                if ("int".equalsIgnoreCase(type) || "java.lang.Integer".equalsIgnoreCase(type)) {
                    if ("".equals(v.trim())) {
                        v = "0";
                    }
                    if (value instanceof Boolean) {
                        v = (Boolean)value != false ? "1" : "0";
                    }
                    m.invoke(t, Integer.parseInt(v));
                    continue;
                }
                if ("long".equalsIgnoreCase(type) || "java.lang.Long".equalsIgnoreCase(type)) {
                    if ("".equals(v.trim())) {
                        v = "0";
                    }
                    if (value instanceof Boolean) {
                        v = (Boolean)value != false ? "1" : "0";
                    }
                    m.invoke(t, Long.parseLong(v));
                    continue;
                }
                if ("float".equalsIgnoreCase(type) || "java.lang.Float".equalsIgnoreCase(type)) {
                    if ("".equals(v.trim())) {
                        v = "0.0";
                    }
                    if (value instanceof Boolean) {
                        v = (Boolean)value != false ? "1.0" : "0.0";
                    }
                    m.invoke(t, Float.valueOf(Float.parseFloat(v)));
                    continue;
                }
                if ("double".equalsIgnoreCase(type) || "java.lang.Double".equalsIgnoreCase(type)) {
                    if ("".equals(v.trim())) {
                        v = "0.0";
                    }
                    if (value instanceof Boolean) {
                        v = (Boolean)value != false ? "1.0" : "0.0";
                    }
                    m.invoke(t, Double.parseDouble(v));
                    continue;
                }
                if ("string".equalsIgnoreCase(type) || "java.lang.String".equalsIgnoreCase(type)) {
                    m.invoke(t, v);
                    continue;
                }
                if ("boolean".equalsIgnoreCase(type) || "java.lang.Boolean".equalsIgnoreCase(type)) {
                    if ("1".equals(v.trim()) || "true".equals(v.trim())) {
                        m.invoke(t, true);
                        continue;
                    }
                    if (!"0".equals(v.trim()) && !"false".equals(v.trim())) continue;
                    m.invoke(t, false);
                    continue;
                }
                if ("date".equalsIgnoreCase(type) || "java.sql.Date".equalsIgnoreCase(type) || "java.util.Date".equalsIgnoreCase(type)) {
                    m.invoke(t, value);
                    continue;
                }
                if ("timestamp".equalsIgnoreCase(type) || "java.sql.Timestamp".equalsIgnoreCase(type)) {
                    m.invoke(t, value);
                    continue;
                }
                if ("time".equalsIgnoreCase(type) || "java.sql.Time".equalsIgnoreCase(type)) {
                    m.invoke(t, value);
                    continue;
                }
                if ("byte[]".equalsIgnoreCase(type) || "[Ljava.lang.Byte;".equalsIgnoreCase(type)) {
                    m.invoke(t, value);
                    continue;
                }
                if ("oneOne".equalsIgnoreCase(type) || "manyOne".equalsIgnoreCase(type)) {
                    if ("".equals(v)) continue;
                    Field field = ru.getField(p.getName());
                    Class<?> tarClass = field.getType();
                    String refField = p.getRelProperty();
                    Object tarObj = tarClass.newInstance();
                    tarObj = ClassUtil.injectFieldValue(tarObj, refField, new String[]{v});
                    m.invoke(t, tarObj);
                    continue;
                }
                if ("oneMany".equalsIgnoreCase(type) || "manyMany".equalsIgnoreCase(type) || "".equals(type)) continue;
                m.invoke(t, String.valueOf(value));
            }
            list.add(t);
        }
        return list.isEmpty() ? null : list;
    }

    public static String calculateTime(long start) {
        return CommonUtil.calculateTime(start, System.currentTimeMillis(), "${d}d ${h}h${m}m${s}s");
    }

    public static String calculateTime(long start, String format) {
        return CommonUtil.calculateTime(start, System.currentTimeMillis(), format);
    }

    public static String calculateTime(long start, long end) {
        return CommonUtil.calculateTime(start, end, "${d}d ${h}h${m}m${s}s");
    }

    public static String calculateTime(long start, long end, String format) {
        if (format == null) {
            format = "${d}d ${h}h${m}m${s}s";
        }
        long between = end - start;
        long d = between / 86400000L;
        long h = between / 3600000L - d * 24L;
        long m = between / 60000L - d * 24L * 60L - h * 60L;
        long s = between / 1000L - d * 24L * 60L * 60L - h * 60L * 60L - m * 60L;
        return format.replace("${d}", String.valueOf(d)).replace("${h}", String.valueOf(h)).replace("${m}", String.valueOf(m)).replace("${s}", String.valueOf(s));
    }

    public static Float toSeconds(String strTime) {
        Float time = Float.valueOf(0.0f);
        String[] stringArray = strTime.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            time = Float.valueOf(time.floatValue() + CommonUtil._toSeconds(s).floatValue());
            ++n2;
        }
        return time;
    }

    private static Float _toSeconds(String strTime) {
        Float time = Float.valueOf(0.0f);
        try {
            time = strTime.endsWith("s") ? Float.valueOf(Float.parseFloat(strTime.replace("s", "")) * 1.0f) : (strTime.endsWith("m") ? Float.valueOf(Float.parseFloat(strTime.replace("m", "")) * 60.0f) : (strTime.endsWith("h") ? Float.valueOf(Float.parseFloat(strTime.replace("h", "")) * 60.0f * 60.0f) : (strTime.endsWith("d") ? Float.valueOf(Float.parseFloat(strTime.replace("d", "")) * 60.0f * 60.0f * 24.0f) : Float.valueOf(Float.parseFloat(strTime)))));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return time;
    }

    public static boolean isSameHost(String hostUrl, String url) throws Exception {
        URL siteURL = new URL(hostUrl);
        URL currURL = new URL(url);
        String siteHost = siteURL.getHost();
        String currHost = currURL.getHost();
        return siteHost.equals(currHost);
    }

    public static String findOneByRegex(String input, String regex) {
        List<String> list = CommonUtil.findByRegex(input, regex);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public static List<String> findByRegex(String input, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(input);
        while (m.find()) {
            result.add(m.group());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public static byte[] long2ByteArray(long l) {
        byte[] array = new byte[8];
        int i = 0;
        int shift = 56;
        while (i < 8) {
            array[i] = (byte)(0xFFL & l >> shift);
            ++i;
            shift -= 8;
        }
        return array;
    }

    public static byte[] int2ByteArray(int value) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            int offset = (3 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
            ++i;
        }
        return b;
    }

    public static void putIntInByteArray(int value, byte[] buf, int offset) {
        int i = 0;
        while (i < 4) {
            int valueOffset = (3 - i) * 8;
            buf[offset + i] = (byte)(value >>> valueOffset & 0xFF);
            ++i;
        }
    }

    public static int byteArray2Int(byte[] b) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    public static long byteArray2Long(byte[] b) {
        int value = 0;
        int i = 0;
        while (i < 8) {
            int shift = (7 - i) * 8;
            value += (b[i] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    public static boolean hasBinaryContent(String contentType) {
        String typeStr;
        return contentType != null && ((typeStr = contentType.toLowerCase()).contains("image") || typeStr.contains("audio") || typeStr.contains("video") || typeStr.contains("application"));
    }

    public static boolean hasPlainTextContent(String contentType) {
        String typeStr;
        return contentType != null && (typeStr = contentType.toLowerCase()).contains("text/plain");
    }

    public static String toFriendlySeoTitle(String url) {
        return Normalizer.normalize(url.toLowerCase(), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[^\\p{Alnum}]+", "-").replaceAll("[^a-zA-Z0-9]+$", "").replaceAll("^[^a-zA-Z0-9]+", "");
    }

    public static Long getNow() {
        return System.currentTimeMillis();
    }

    public static Long getNow(int length) {
        return CommonUtil.getTime(length, new Date());
    }

    public static Long getTime(int length, Date date) {
        String time = String.valueOf(date.getTime()).substring(0, length);
        return Long.parseLong(time);
    }

    public static String md5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input.getBytes());
            byte[] output = md.digest();
            return CommonUtil.bytesToHex(output);
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
    }

    public static String bytesToHex(byte[] b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < b.length) {
            buf.append(hexDigit[b[j] >> 4 & 0xF]);
            buf.append(hexDigit[b[j] & 0xF]);
            ++j;
        }
        return buf.toString();
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        if (str.isEmpty()) {
            return true;
        }
        return str.trim().isEmpty();
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String resoveTime(String time) {
        String[] array = time.split(":");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(":");
            }
            if (a.length() == 1) {
                a = "0" + a;
            }
            sb.append(a);
            ++n2;
        }
        return String.valueOf(sb.toString()) + ":00";
    }

    public static Date resoveDate(String date) throws Exception {
        Date d = null;
        try {
            d = CommonUtil.parse("yyyy-MM-dd", date);
        }
        catch (Throwable e1) {
            try {
                d = CommonUtil.parse("yyyy-M-dd", date);
            }
            catch (Throwable e2) {
                try {
                    d = CommonUtil.parse("yyyy-MM-d", date);
                }
                catch (Throwable e3) {
                    try {
                        d = CommonUtil.parse("yyyy-M-d", date);
                    }
                    catch (Throwable e4) {
                        try {
                            d = CommonUtil.parse("MM/dd/yyyy", date);
                        }
                        catch (Throwable e5) {
                            try {
                                d = CommonUtil.parse("MM/d/yyyy", date);
                            }
                            catch (Throwable e6) {
                                try {
                                    d = CommonUtil.parse("M/dd/yyyy", date);
                                }
                                catch (Throwable e7) {
                                    try {
                                        d = CommonUtil.parse("M/d/yyyy", date);
                                    }
                                    catch (Throwable e8) {
                                        throw new Exception(e8);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    public static boolean isValidTime(String str) {
        return str.matches("^\\d{2}:\\d{2}:\\d{2}$");
    }

    public static boolean isValidDate(String str) {
        return str != null ? str.matches("^\\d{4}(\\-|\\/|\\.)\\d{1,2}\\1\\d{1,2}$") : false;
    }

    public static boolean isValidDateTime(String source) {
        return CommonUtil.isValidDateTime(source, Locale.getDefault());
    }

    public static boolean isValidDateTime(String source, Locale locale) {
        return CommonUtil.isValidDateTime(source, "yyyy-MM-dd HH:mm:ss", locale);
    }

    public static boolean isValidDateTime(String source, String format) {
        return CommonUtil.isValidDateTime(source, format, Locale.getDefault());
    }

    public static boolean isValidDateTime(String source, String format, Locale locale) {
        try {
            Date date = CommonUtil.parse(format, source, locale);
            return date != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static <T> List<T> parseArray(String json, Class<T> clazz) {
        return JSON.parseArray((String)json, clazz);
    }

    public static <T> T parse(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static String toJson(Object object) {
        return CommonUtil.toJson(object, null);
    }

    public static String toJson(Object object, SerializerFeature[] features) {
        if (features == null || features.length == 0) {
            features = new SerializerFeature[]{SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullStringAsEmpty};
        }
        return JSON.toJSONString((Object)object, (SerializerFeature[])features);
    }

    public static String percent(long a, long b) {
        double k = (double)a / (double)b * 100.0;
        BigDecimal big = new BigDecimal(k);
        return String.valueOf(big.setScale(2, 4).doubleValue()) + "%";
    }

    public static long[] changeSecondsToTime(long seconds) {
        long hour = seconds / 3600L;
        long minute = (seconds - hour * 3600L) / 60L;
        long second = seconds - hour * 3600L - minute * 60L;
        return new long[]{hour, minute, second};
    }

    public static int getDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(6);
    }

    public static int getLastDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(6);
    }

    public static int getDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(5);
    }

    public static int getDayOfWeek(Date date) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTime(date);
        int x = aCalendar.get(7);
        return x;
    }

    public static int getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(7);
    }

    public static long difference(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        if (cal2.after(cal1)) {
            return cal2.getTimeInMillis() - cal1.getTimeInMillis();
        }
        return cal1.getTimeInMillis() - cal2.getTimeInMillis();
    }

    public static Date addSecond(Date source, int s) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(source);
        cal.add(13, s);
        return cal.getTime();
    }

    public static Date addMinute(Date source, int min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(source);
        cal.add(12, min);
        return cal.getTime();
    }

    public static Date addHour(Date source, int hour) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(source);
        cal.add(11, hour);
        return cal.getTime();
    }

    public static Date addDay(Date source, int day) {
        return CommonUtil.addDate(source, day);
    }

    public static Date addDate(Date source, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(source);
        cal.add(5, day);
        return cal.getTime();
    }

    public static Date addMonth(Date source, int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(source);
        cal.add(2, month);
        return cal.getTime();
    }

    public static Date addYear(Date source, int year) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(source);
        cal.add(1, year);
        return cal.getTime();
    }

    public static Date parse(String format, String source) {
        return CommonUtil.parse(format, source, Locale.getDefault());
    }

    public static Locale getLocale(String lang) {
        Locale[] locs;
        Locale[] localeArray = locs = Locale.getAvailableLocales();
        int n = locs.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            if (lang.equals(l.getLanguage())) {
                return l;
            }
            ++n2;
        }
        return Locale.ENGLISH;
    }

    public static Date parse(String format, String source, Locale locale) {
        int aaIndex = format.indexOf(" aa");
        if (aaIndex > -1) {
            String apm = source.substring(aaIndex + 1, aaIndex + 1 + 2);
            format = format.replace(" aa", "");
            return CommonUtil.parse(format, source.substring(0, aaIndex), apm, locale);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        try {
            return sdf.parse(source);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parse(String format, String source, String amOrPm) {
        return CommonUtil.parse(format, source, amOrPm, Locale.getDefault());
    }

    public static Date parse(String format, String source, String amOrPm, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        try {
            Date date = sdf.parse(source);
            int HH = CommonUtil.toInt(CommonUtil.formatTime("HH", date));
            if ("PM".equalsIgnoreCase(amOrPm)) {
                if (HH <= 12) {
                    date = CommonUtil.addHour(date, 12);
                }
            } else if ("AM".equalsIgnoreCase(amOrPm) && HH >= 12) {
                date = CommonUtil.addHour(date, -12);
            }
            return date;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parse(String source) {
        return CommonUtil.parse(source, Locale.getDefault());
    }

    public static Date parse(String source, Locale locale) {
        return CommonUtil.parse("yyyy-MM-dd HH:mm:ss", source, locale);
    }

    public static String upperFirst(String s) {
        return s.replaceFirst(s.substring(0, 1), s.substring(0, 1).toUpperCase());
    }

    public static Map<String, Object> map(String k, Object v) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(k, v);
        return map;
    }

    public static Map<String, Object> map(String[] keys, Object[] values) {
        HashMap<String, Object> map = new HashMap<String, Object>(keys.length);
        int i = 0;
        while (i < keys.length) {
            map.put(keys[i], values[i]);
            ++i;
        }
        return map;
    }

    public static long[] splitToLong(String source, String by) {
        if (source == null || source.trim().length() == 0 || by == null || by.trim().length() == 0) {
            return null;
        }
        String[] strs = source.split(by);
        long[] longs = new long[strs.length];
        int i = 0;
        while (i < strs.length) {
            longs[i] = Long.parseLong(strs[i]);
            ++i;
        }
        return longs;
    }

    public static int[] splitToInt(String source, String by) {
        if (source == null || by == null) {
            return null;
        }
        String[] strs = source.split(by);
        int[] ints = new int[strs.length];
        int i = 0;
        while (i < strs.length) {
            ints[i] = Integer.parseInt(strs[i]);
            ++i;
        }
        return ints;
    }

    public static String formatTime(Date date) {
        return CommonUtil.formatTime(null, date);
    }

    public static String formatTime(String format, Date date) {
        if (format == null) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        String time = new SimpleDateFormat(format).format(date);
        return time;
    }

    public static Date newDate() {
        return new Date();
    }

    public static Date newDate(String pattern, String time) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.parse(time);
        }
        catch (ParseException e) {
            throw new RuntimeException();
        }
    }

    public static String formatStr(String format, Object ... args) {
        return String.format(format, args);
    }

    public static boolean isValidEmail(String mail) {
        String regex = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(mail);
        return m.find();
    }

    public static String formatFileSize(long size, String format) {
        if (format.equals("K")) {
            return String.valueOf((double)size / 1024.0) + "K";
        }
        if (format.equals("M")) {
            return String.valueOf((double)size / 1024.0 / 1024.0) + "M";
        }
        if (format.equals("G")) {
            return String.valueOf((double)size / 1024.0 / 1024.0 / 1024.0) + "G";
        }
        if (format.equals("T")) {
            return String.valueOf((double)size / 1024.0 / 1024.0 / 1024.0 / 1024.0) + "T";
        }
        return String.valueOf(size) + "B";
    }

    public static long parseFileSize(String _size) {
        if (_size.toUpperCase().endsWith("K")) {
            long size = Long.parseLong(_size.toUpperCase().replace("K", ""));
            return size * 1024L;
        }
        if (_size.toUpperCase().endsWith("M")) {
            long size = Long.parseLong(_size.toUpperCase().replace("M", ""));
            return size * 1024L * 1024L;
        }
        if (_size.toUpperCase().endsWith("G")) {
            long size = Long.parseLong(_size.toUpperCase().replace("G", ""));
            return size * 1024L * 1024L * 1024L;
        }
        return Long.parseLong(_size);
    }

    public static String replaceChinese2Utf8(String source) {
        String str = source;
        try {
            Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]+");
            Matcher matcher = pattern.matcher(source);
            while (matcher.find()) {
                String g = matcher.group();
                str = source.replace(g, URLEncoder.encode(g, "utf-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String parsePropValue(String source) {
        return CommonUtil.parsePropValue(source, null);
    }

    public static String parsePropValue(String source, String _propId) {
        if (_propId != null) {
            return CommonUtil.parseSinglePropVarable(source, _propId);
        }
        Pattern pattern = Pattern.compile("\\$\\{[-a-zA-Z0-9_\u4e00-\u9fa5]+\\.[-a-zA-Z0-9_\u4e00-\u9fa5]+\\}");
        Matcher matcher = pattern.matcher(source);
        if (!matcher.find()) {
            return source;
        }
        String g = matcher.group();
        String suffix = source.replace(g, "");
        String[] props = g.replace("${", "").replace("}", "").split("\\.");
        String prefix = null;
        if (props.length == 2) {
            String propId = props[0];
            String key = props[1];
            prefix = "global".equals(propId) ? Props.get(key) : Props.getMap(propId).get(key);
            source = String.valueOf(prefix) + suffix;
        }
        return source;
    }

    public static String parseSinglePropVarable(String source, String propId) {
        Pattern pattern = Pattern.compile("\\$\\{[-a-zA-Z0-9_\u4e00-\u9fa5\\.,;:\\|]+\\}");
        Matcher matcher = pattern.matcher(source);
        if (!matcher.find()) {
            return source;
        }
        String g = matcher.group();
        String suffix = source.replace(g, "");
        String key = g.replace("${", "").replace("}", "");
        String prefix = null;
        prefix = "global".equals(propId) ? Props.get(key) : Props.getMap(propId).get(key);
        if (prefix != null) {
            source = String.valueOf(prefix) + suffix;
        }
        return source;
    }

    public static Date strToDate(String source, String pattern) {
        Date date = null;
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            date = format.parse(source);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String dateToStr(Date source, String pattern) {
        String result = null;
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        result = format.format(source);
        return result;
    }

    public static int strToInt(String source) {
        int result = 0;
        try {
            result = Integer.parseInt(source);
        }
        catch (NumberFormatException e) {
            result = 0;
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String toUpCaseFirst(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        char[] temp = str.toCharArray();
        temp[0] = str.toUpperCase().toCharArray()[0];
        str = String.valueOf(temp);
        return str;
    }

    public static String toLowCaseFirst(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        char[] temp = str.toCharArray();
        temp[0] = str.toLowerCase().toCharArray()[0];
        str = String.valueOf(temp);
        return str;
    }

    public static String[] toUpCaseFirst(String[] str) {
        if (str == null || str.length == 0) {
            return str;
        }
        String[] result = new String[str.length];
        int i = 0;
        while (i < result.length) {
            result[i] = CommonUtil.toUpCaseFirst(str[i]);
            ++i;
        }
        return result;
    }

    public static String[] toLowCaseFirst(String[] str) {
        if (str == null || str.length == 0) {
            return str;
        }
        String[] result = new String[str.length];
        int i = 0;
        while (i < result.length) {
            result[i] = CommonUtil.toLowCaseFirst(str[i]);
            ++i;
        }
        return result;
    }

    public static String hump2ohter(String param, String aother) {
        char other = aother.toCharArray()[0];
        Pattern p = Pattern.compile("[A-Z]");
        if (param == null || param.equals("")) {
            return "";
        }
        StringBuilder builder = new StringBuilder(param);
        Matcher mc = p.matcher(param);
        int i = 0;
        while (mc.find()) {
            builder.replace(mc.start() + i, mc.end() + i, String.valueOf(other) + mc.group().toLowerCase());
            ++i;
        }
        if (other == builder.charAt(0)) {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    public static boolean verifyWord(String input, String regex) {
        if (input == null) {
            input = "";
        }
        if (regex == null) {
            regex = "";
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        boolean flag = m.matches();
        return flag;
    }

    public static String changeHTML(String source) {
        String s0 = source.replace("\t\n", "<br />");
        String s1 = s0.replace("&", "&amp;");
        String s2 = s1.replace(" ", "&nbsp;");
        String s3 = s2.replace("<", "&lt;");
        String s4 = s3.replace(">", "&gt;");
        String s5 = s4.replace("\"", "&quot;");
        String s6 = s5.replace("'", "&apos;");
        return s6;
    }

    public static String toHTML(String source) {
        String s1 = source.replace("&amp;", "&");
        String s2 = s1.replace("&nbsp;", " ");
        String s3 = s2.replace("&lt;", "<");
        String s4 = s3.replace("&gt;", ">");
        String s5 = s4.replace("<br />", "\t\n");
        String s6 = s5.replace("&quot;", "\"");
        String s7 = s6.replace("&apos;", "'");
        return s7;
    }

    public static String getNowTime(String format, Locale loc) {
        if (format == null) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        if (loc == null) {
            return new SimpleDateFormat(format).format(Calendar.getInstance().getTime());
        }
        return new SimpleDateFormat(format, loc).format(Calendar.getInstance().getTime());
    }

    public static String getNowTime(String format) {
        return CommonUtil.getNowTime(format, null);
    }

    public static String getNowTime() {
        return CommonUtil.getNowTime(null);
    }

    public static String toEncoding(String str, String encoding) {
        if (str == null) {
            str = "";
        }
        try {
            str = new String(str.getBytes("ISO-8859-1"), encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String cutArrayBySepara(String[] source, String separator) {
        if (source == null || source.length == 0 || separator == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < source.length) {
            if (i == source.length - 1) {
                result.append(source[i]);
            } else {
                result.append(source[i]).append(separator);
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean isNullOrEmpty(Object obj) {
        return obj == null || "".equals(obj.toString());
    }

    public static String join(Collection<?> s, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<?> iter = s.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
            } else {
                byte[] b;
                try {
                    b = Character.toString(c).getBytes("utf-8");
                }
                catch (Exception ex) {
                    b = new byte[]{};
                }
                int j = 0;
                while (j < b.length) {
                    int k = b[j];
                    if (k < 0) {
                        k += 256;
                    }
                    sb.append("%" + Integer.toHexString(k).toUpperCase());
                    ++j;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String uriDecoding(String str) {
        String result = str;
        try {
            result = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getExceptionString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)strWriter, true);
        e.printStackTrace(writer);
        StringBuffer sb = strWriter.getBuffer();
        String s = "cause by: \n\t" + sb.toString();
        return s.replace("Caused by:", "<font color='red'>Caused by:");
    }

    @Deprecated
    public static String getStack(StackTraceElement[] stes) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = stes;
        int n = stes.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            if (ste != null) {
                sb.append("\n").append(ste.toString());
            }
            ++n2;
        }
        return sb.toString();
    }

    @Deprecated
    public static String resoveUrl(String relativeUrl, String baseUrl) {
        return CommonUtil.resolveUrl(baseUrl, relativeUrl);
    }

    public static String resolveUrl(String baseUrl, String relativeUrl) {
        if (baseUrl == null) {
            return relativeUrl;
        }
        if (relativeUrl == null || relativeUrl.trim().length() == 0) {
            return null;
        }
        Url url = CommonUtil.resolveUrl(CommonUtil.parseUrl(baseUrl.trim()), relativeUrl.trim());
        return url.toString();
    }

    private static Url parseUrl(String spec) {
        int semicolonIndex;
        int questionMarkIndex;
        int locationEndIndex;
        int locationStartIndex;
        String scheme;
        int colonIndex;
        Url url = new Url();
        int startIndex = 0;
        int endIndex = spec.length();
        int crosshatchIndex = CommonUtil.indexOf(spec, '#', startIndex, endIndex);
        if (crosshatchIndex >= 0) {
            url.fragment_ = spec.substring(crosshatchIndex + 1, endIndex);
            endIndex = crosshatchIndex;
        }
        if ((colonIndex = CommonUtil.indexOf(spec, ':', startIndex, endIndex)) > 0 && CommonUtil.isValidScheme(scheme = spec.substring(startIndex, colonIndex))) {
            url.scheme_ = scheme;
            startIndex = colonIndex + 1;
        }
        if (spec.startsWith("//", startIndex)) {
            locationStartIndex = startIndex + 2;
            locationEndIndex = CommonUtil.indexOf(spec, '/', locationStartIndex, endIndex);
            if (locationEndIndex >= 0) {
                startIndex = locationEndIndex;
            }
        } else {
            locationStartIndex = -1;
            locationEndIndex = -1;
        }
        if ((questionMarkIndex = CommonUtil.indexOf(spec, '?', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = questionMarkIndex;
                startIndex = questionMarkIndex;
            }
            url.query_ = spec.substring(questionMarkIndex + 1, endIndex);
            endIndex = questionMarkIndex;
        }
        if ((semicolonIndex = CommonUtil.indexOf(spec, ';', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = semicolonIndex;
                startIndex = semicolonIndex;
            }
            url.parameters_ = spec.substring(semicolonIndex + 1, endIndex);
            endIndex = semicolonIndex;
        }
        if (locationStartIndex >= 0 && locationEndIndex < 0) {
            locationEndIndex = endIndex;
        } else if (startIndex < endIndex) {
            url.path_ = spec.substring(startIndex, endIndex);
        }
        if (locationStartIndex >= 0 && locationEndIndex >= 0) {
            url.location_ = spec.substring(locationStartIndex, locationEndIndex);
        }
        return url;
    }

    private static boolean isValidScheme(String scheme) {
        int length = scheme.length();
        if (length < 1) {
            return false;
        }
        char c = scheme.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        int i = 1;
        while (i < length) {
            c = scheme.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Url resolveUrl(Url baseUrl, String relativeUrl) {
        int slashIndex;
        String pathSegment;
        int pathSegmentIndex;
        Url url = CommonUtil.parseUrl(relativeUrl);
        if (baseUrl == null) {
            return url;
        }
        if (relativeUrl.length() == 0) {
            return new Url(baseUrl);
        }
        if (url.scheme_ != null) {
            return url;
        }
        url.scheme_ = baseUrl.scheme_;
        if (url.location_ != null) {
            return url;
        }
        url.location_ = baseUrl.location_;
        if (url.path_ != null && url.path_.startsWith("/")) {
            url.path_ = CommonUtil.removeLeadingSlashPoints(url.path_);
            return url;
        }
        if (url.path_ == null) {
            url.path_ = baseUrl.path_;
            if (url.parameters_ != null) {
                return url;
            }
            url.parameters_ = baseUrl.parameters_;
            if (url.query_ != null) {
                return url;
            }
            url.query_ = baseUrl.query_;
            return url;
        }
        String basePath = baseUrl.path_;
        String path = new String();
        if (basePath != null) {
            int lastSlashIndex = basePath.lastIndexOf(47);
            if (lastSlashIndex >= 0) {
                path = basePath.substring(0, lastSlashIndex + 1);
            }
        } else {
            path = "/";
        }
        path = path.concat(url.path_);
        while ((pathSegmentIndex = path.indexOf("/./")) >= 0) {
            path = path.substring(0, pathSegmentIndex + 1).concat(path.substring(pathSegmentIndex + 3));
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        while ((pathSegmentIndex = path.indexOf("/../")) > 0) {
            pathSegment = path.substring(0, pathSegmentIndex);
            slashIndex = pathSegment.lastIndexOf(47);
            if (slashIndex < 0 || pathSegment.substring(slashIndex).equals("..")) continue;
            path = path.substring(0, slashIndex + 1).concat(path.substring(pathSegmentIndex + 4));
        }
        if (path.endsWith("/..") && (slashIndex = (pathSegment = path.substring(0, path.length() - 3)).lastIndexOf(47)) >= 0) {
            path = path.substring(0, slashIndex + 1);
        }
        path = CommonUtil.removeLeadingSlashPoints(path);
        url.path_ = path;
        return url;
    }

    private static String removeLeadingSlashPoints(String path) {
        while (path.startsWith("/..")) {
            path = path.substring(3);
        }
        return path;
    }

    public static boolean startsWithIgnoreCase(String stringToCheck, String prefix) {
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Prefix may not be empty");
        }
        int prefixLength = prefix.length();
        if (stringToCheck.length() < prefixLength) {
            return false;
        }
        return stringToCheck.substring(0, prefixLength).toLowerCase().equals(prefix.toLowerCase());
    }

    public static int indexOf(String s, char searchChar, int beginIndex, int endIndex) {
        int i = beginIndex;
        while (i < endIndex) {
            if (s.charAt(i) == searchChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class Url {
        private String scheme_;
        private String location_;
        private String path_;
        private String parameters_;
        private String query_;
        private String fragment_;

        public Url(Url url) {
            this.scheme_ = url.scheme_;
            this.location_ = url.location_;
            this.path_ = url.path_;
            this.parameters_ = url.parameters_;
            this.query_ = url.query_;
            this.fragment_ = url.fragment_;
        }

        public Url() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.scheme_ != null) {
                sb.append(this.scheme_);
                sb.append(':');
            }
            if (this.location_ != null) {
                sb.append("//");
                sb.append(this.location_);
            }
            if (this.path_ != null) {
                sb.append(this.path_);
            }
            if (this.parameters_ != null) {
                sb.append(';');
                sb.append(this.parameters_);
            }
            if (this.query_ != null) {
                sb.append('?');
                sb.append(this.query_);
            }
            if (this.fragment_ != null) {
                sb.append('#');
                sb.append(this.fragment_);
            }
            return sb.toString();
        }
    }
}

