/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.sql.Sql;
import org.eweb4j.orm.sql.SqlCreateException;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSqlCreator<T> {
    private T[] ts;

    public UpdateSqlCreator(T[] ts) {
        Object[] tmp = null;
        if (ts != null && ts.length > 0) {
            tmp = ts;
        }
        this.ts = tmp;
    }

    public Sql[] update(String condition) {
        Sql[] sqls = new Sql[this.ts.length];
        if (this.ts != null && this.ts.length > 0) {
            int i = 0;
            while (i < this.ts.length) {
                sqls[i] = this.makeSQL(this.ts[i], condition);
                ++i;
            }
        }
        return sqls;
    }

    private Sql makeSQL(T t, String condition) {
        Sql sql = new Sql();
        Class<?> clazz = t.getClass();
        String table = ORMConfigBeanUtil.getTable(clazz, false);
        sql.sql = String.format("UPDATE %s %s ;", table, condition);
        return sql;
    }

    public Sql[] update() throws SqlCreateException {
        Sql[] sqls = new Sql[this.ts.length];
        int i = 0;
        while (i < this.ts.length) {
            sqls[i] = this.makeSQL(this.ts[i]);
            ++i;
        }
        return sqls;
    }

    public Sql[] update(String ... fields) throws SqlCreateException {
        Sql[] sqls = new Sql[this.ts.length];
        int i = 0;
        while (i < this.ts.length) {
            sqls[i] = this.makeSQL(this.ts[i], fields);
            ++i;
        }
        return sqls;
    }

    public Sql[] update(String[] fields, Object[] values) throws SqlCreateException {
        Sql[] sqls = new Sql[this.ts.length];
        int i = 0;
        while (i < this.ts.length) {
            sqls[i] = this.makeSQL(this.ts[i], fields, values);
            ++i;
        }
        return sqls;
    }

    private Sql makeSQL(T t) throws SqlCreateException {
        String[] fields;
        String[] columns;
        String idField;
        String idColumn;
        String table;
        Sql sql = new Sql();
        Class<?> clazz = t.getClass();
        Object[] values = null;
        Object idValue = null;
        HashMap map = null;
        if (Map.class.isAssignableFrom(clazz)) {
            map = (HashMap)t;
            table = (String)map.get("table");
            idField = idColumn = (String)map.get("idColumn");
            idValue = map.get("idValue");
            columns = (String[])map.get("columns");
            fields = columns;
            values = (Object[])map.get("values");
        } else {
            table = ORMConfigBeanUtil.getTable(clazz, false);
            columns = ORMConfigBeanUtil.getColumns(clazz);
            fields = ORMConfigBeanUtil.getFields(clazz);
            idColumn = ORMConfigBeanUtil.getIdColumn(clazz);
            idField = ORMConfigBeanUtil.getIdField(clazz);
        }
        StringBuilder valuesSb = new StringBuilder();
        ReflectUtil ru = new ReflectUtil(t);
        try {
            if (map == null) {
                Method idGetter = ru.getGetter(idField);
                if (idGetter == null) {
                    throw new SqlCreateException("can not find id getter");
                }
                idValue = idGetter.invoke(t, new Object[0]);
            }
            int i = 0;
            while (i < columns.length) {
                block15: {
                    Object value;
                    String column;
                    block17: {
                        Object _value;
                        block18: {
                            String field;
                            block16: {
                                column = columns[i];
                                field = fields[i];
                                value = null;
                                if (idColumn != null && idColumn.equalsIgnoreCase(column)) break block15;
                                if (map == null || values == null) break block16;
                                value = values[i];
                                break block17;
                            }
                            Method getter = ru.getGetter(field);
                            if (getter == null || (_value = getter.invoke(t, new Object[0])) == null) break block15;
                            if (!ClassUtil.isPojo(_value.getClass())) break block18;
                            Field f = ru.getField(field);
                            OneToOne oneAnn = getter.getAnnotation(OneToOne.class);
                            if (oneAnn == null) {
                                oneAnn = f.getAnnotation(OneToOne.class);
                            }
                            ManyToOne manyToOneAnn = null;
                            if (oneAnn == null && (manyToOneAnn = getter.getAnnotation(ManyToOne.class)) == null) {
                                manyToOneAnn = f.getAnnotation(ManyToOne.class);
                            }
                            if (oneAnn != null || manyToOneAnn != null) {
                                JoinColumn joinColAnn = getter.getAnnotation(JoinColumn.class);
                                if (joinColAnn == null) {
                                    joinColAnn = f.getAnnotation(JoinColumn.class);
                                }
                                if (joinColAnn != null && joinColAnn.referencedColumnName().trim().length() > 0) {
                                    String refCol = joinColAnn.referencedColumnName();
                                    String refField = ORMConfigBeanUtil.getField(_value.getClass(), refCol);
                                    ReflectUtil tarRu = new ReflectUtil(_value);
                                    Method tarFKGetter = tarRu.getGetter(refField);
                                    value = tarFKGetter.invoke(_value, new Object[0]);
                                } else {
                                    ReflectUtil tarRu = new ReflectUtil(_value);
                                    String tarFKField = ORMConfigBeanUtil.getIdField(_value.getClass());
                                    if (tarFKField != null) {
                                        Method tarFKGetter = tarRu.getGetter(tarFKField);
                                        value = tarFKGetter.invoke(_value, new Object[0]);
                                    }
                                }
                            }
                            if (value != null) break block17;
                            break block15;
                        }
                        value = _value;
                    }
                    if (valuesSb.length() > 0) {
                        valuesSb.append(",");
                    }
                    valuesSb.append(column).append(" = ? ");
                    sql.args.add(value);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new SqlCreateException(e.toString(), e);
        }
        String condition = idColumn + " = ? ";
        sql.args.add(idValue);
        sql.sql = String.format("UPDATE %s SET %s WHERE %s ;", table, valuesSb, condition);
        return sql;
    }

    private Sql makeSQL(T t, String[] fields) throws SqlCreateException {
        Sql sql = new Sql();
        Class<?> clazz = t.getClass();
        if (fields == null || fields.length == 0) {
            fields = ORMConfigBeanUtil.getFields(clazz);
        }
        String table = ORMConfigBeanUtil.getTable(clazz, false);
        StringBuilder values = new StringBuilder();
        ReflectUtil ru = new ReflectUtil(t);
        String[] columns = ORMConfigBeanUtil.getColumns(clazz, fields);
        String idColumn = ORMConfigBeanUtil.getIdColumn(clazz);
        String idField = ORMConfigBeanUtil.getIdField(clazz);
        Method idGetter = ru.getGetter(idField);
        if (idGetter == null) {
            throw new SqlCreateException("can not find id getter.");
        }
        Object idValue = null;
        try {
            idValue = idGetter.invoke(t, new Object[0]);
        }
        catch (Exception e) {
            throw new SqlCreateException(idGetter + " invoke exception " + e.toString(), e);
        }
        int i = 0;
        while (i < fields.length) {
            block19: {
                String field = fields[i];
                String column = columns[i];
                Method getter = ru.getGetter(field);
                if (getter != null) {
                    try {
                        Object _value = getter.invoke(t, new Object[0]);
                        if (_value == null) break block19;
                        Object value = null;
                        if (ClassUtil.isPojo(_value.getClass())) {
                            Field f = ru.getField(field);
                            OneToOne oneAnn = getter.getAnnotation(OneToOne.class);
                            if (oneAnn == null) {
                                oneAnn = f.getAnnotation(OneToOne.class);
                            }
                            ManyToOne manyToOneAnn = null;
                            if (oneAnn == null && (manyToOneAnn = getter.getAnnotation(ManyToOne.class)) == null) {
                                manyToOneAnn = f.getAnnotation(ManyToOne.class);
                            }
                            if (oneAnn != null || manyToOneAnn != null) {
                                JoinColumn joinColAnn = getter.getAnnotation(JoinColumn.class);
                                if (joinColAnn == null) {
                                    joinColAnn = f.getAnnotation(JoinColumn.class);
                                }
                                if (joinColAnn != null && joinColAnn.referencedColumnName().trim().length() > 0) {
                                    String refCol = joinColAnn.referencedColumnName();
                                    String refField = ORMConfigBeanUtil.getField(_value.getClass(), refCol);
                                    ReflectUtil tarRu = new ReflectUtil(_value);
                                    Method tarFKGetter = tarRu.getGetter(refField);
                                    value = tarFKGetter.invoke(_value, new Object[0]);
                                } else {
                                    ReflectUtil tarRu = new ReflectUtil(_value);
                                    String tarFKField = ORMConfigBeanUtil.getIdField(_value.getClass());
                                    if (tarFKField != null) {
                                        Method tarFKGetter = tarRu.getGetter(tarFKField);
                                        value = tarFKGetter.invoke(_value, new Object[0]);
                                    }
                                }
                            }
                            if (value == null) {
                                break block19;
                            }
                        } else {
                            value = _value;
                        }
                        if (values.length() > 0) {
                            values.append(", ");
                        }
                        values.append(column).append(" = ? ");
                        sql.args.add(value);
                    }
                    catch (Exception e) {
                        throw new SqlCreateException(idGetter + " invoke exception " + e.toString(), e);
                    }
                }
            }
            ++i;
        }
        String condition = idColumn + " = ? ";
        sql.args.add(idValue);
        sql.sql = String.format("UPDATE %s SET %s WHERE %s ;", table, values, condition);
        return sql;
    }

    private Sql makeSQL(T t, String[] fields, Object[] values) throws SqlCreateException {
        Sql sql = new Sql();
        Class<?> clazz = t.getClass();
        String table = ORMConfigBeanUtil.getTable(clazz, false);
        ReflectUtil ru = new ReflectUtil(t);
        String[] columns = ORMConfigBeanUtil.getColumns(clazz, fields);
        String idColumn = ORMConfigBeanUtil.getIdColumn(clazz);
        String idField = ORMConfigBeanUtil.getIdField(clazz);
        Method idGetter = ru.getGetter(idField);
        if (idGetter == null) {
            throw new SqlCreateException("can not find id getter.");
        }
        Object idValue = null;
        try {
            idValue = idGetter.invoke(t, new Object[0]);
        }
        catch (Exception e) {
            throw new SqlCreateException(idGetter + " invoke exception " + e.toString(), e);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < columns.length) {
            String column = columns[i];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(column).append(" = ?");
            sql.args.add(values[i]);
            ++i;
        }
        String condition = idColumn + " = ? ";
        sql.args.add(idValue);
        sql.sql = String.format("UPDATE %s SET %s WHERE %s ;", table, sb.toString(), condition);
        return sql;
    }

    public T[] getTs() {
        Object[] tmp = null;
        if (this.ts != null && this.ts.length > 0) {
            tmp = (Object[])this.ts.clone();
        }
        return tmp;
    }

    public void setTs(T[] ts) {
        Object[] tmp = null;
        if (ts != null && ts.length > 0) {
            tmp = (Object[])ts.clone();
        }
        this.ts = tmp;
    }
}

