/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.jdbc;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceWrapCache {
    private static Log log = LogFactory.getORMLogger(DataSourceWrapCache.class);
    private static Hashtable<String, DataSource> ht = new Hashtable();

    public static void put(String key, DataSource ds) {
        log.debug("DataSource -> " + key + " has put into the cache success !");
        ht.put(key, ds);
    }

    public static DataSource get(String key) {
        DataSource ds;
        if (key == null || key.trim().length() == 0) {
            key = "myDBInfo";
        }
        if ((ds = ht.get(key)) == null) {
            log.error("can not create DataSource dsName->" + key);
            throw new RuntimeException("can not create DataSource dsName->" + key);
        }
        return ds;
    }

    public static DataSource get() {
        return DataSourceWrapCache.get(null);
    }

    public static boolean containsKey(String key) {
        return ht.containsKey(key);
    }

    public static boolean contains(DataSource ds) {
        return ht.containsValue(ds);
    }

    public static boolean containsValue(DataSource ds) {
        return ht.containsValue(ds);
    }

    public static void clear() {
        ht.clear();
    }

    public static void remove(String dsName) {
        ht.remove(dsName);
    }

    public static Set<Map.Entry<String, DataSource>> entrySet() {
        return ht.entrySet();
    }
}

