/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.insert;

import java.sql.Connection;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.insert.InsertDAO;
import org.eweb4j.orm.jdbc.JdbcUtil;
import org.eweb4j.orm.sql.Sql;
import org.eweb4j.orm.sql.SqlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertDAOImpl
implements InsertDAO {
    private DataSource ds;
    private String dbType;

    public InsertDAOImpl(DataSource ds, String dbType) {
        this.ds = ds;
        this.dbType = dbType;
    }

    @Override
    public <T> Number[] batchInsert(T[] ts, String ... fields) throws DAOException {
        Number[] ids = null;
        Connection con = null;
        if (ts == null || ts.length == 0) {
            return ids;
        }
        try {
            con = this.ds.getConnection();
            Sql[] sqls = null;
            sqls = fields != null && fields.length > 0 ? SqlFactory.getInsertSql(ts).createByFields(fields) : SqlFactory.getInsertSql(ts).create();
            ArrayList<Object[]> argList = new ArrayList<Object[]>(ts.length);
            Sql[] sqlArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                Sql sql = sqlArray[n2];
                argList.add(sql.args.toArray());
                ++n2;
            }
            Object[][] args = new Object[argList.size()][];
            int i = 0;
            while (i < argList.size()) {
                args[i] = (Object[])argList.get(i);
                ++i;
            }
            ids = JdbcUtil.batchUpdateWithArgs(con, sqls[0].sql, args);
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return ids;
    }

    @Override
    public <T> Number[] batchInsert(T[] ts, String[] fields, Object[] values) throws DAOException {
        Number[] ids = null;
        Connection con = null;
        if (ts == null || ts.length == 0) {
            return ids;
        }
        try {
            con = this.ds.getConnection();
            Sql[] sqls = SqlFactory.getInsertSql(ts).createByFieldsIsValues(fields, values);
            ArrayList<Object[]> argList = new ArrayList<Object[]>(ts.length);
            Sql[] sqlArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                Sql sql = sqlArray[n2];
                argList.add(sql.args.toArray());
                ++n2;
            }
            Object[][] args = new Object[argList.size()][];
            int i = 0;
            while (i < argList.size()) {
                args[i] = (Object[])argList.get(i);
                ++i;
            }
            ids = JdbcUtil.batchUpdateWithArgs(con, sqls[0].sql, args);
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return ids;
    }

    @Override
    public <T> Number insert(T t) throws DAOException {
        Number[] rs = this.batchInsert(new Object[]{t}, new String[0]);
        return rs == null ? (Number)0 : (Number)rs[0];
    }

    @Override
    public <T> Number insertBySql(Class<T> clazz, String sql, Object ... args) throws DAOException {
        Number id = 0;
        if (sql == null) {
            return -1;
        }
        Connection con = null;
        try {
            con = this.ds.getConnection();
            id = JdbcUtil.updateWithArgs(con, sql, args);
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return id;
    }

    @Override
    public <T> Number[] insertByCondition(T[] ts, String condition) throws DAOException {
        Number[] ids = null;
        Connection con = null;
        if (ts == null || ts.length == 0) {
            return ids;
        }
        ids = new Number[ts.length];
        try {
            Sql[] sqls = SqlFactory.getInsertSql(ts).create(condition);
            int i = 0;
            while (i < ts.length) {
                con = this.ds.getConnection();
                ids[i] = JdbcUtil.updateWithArgs(con, sqls[i].sql, sqls[i].args.toArray());
                ++i;
            }
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return ids;
    }

    @Override
    public <T> Number[] insertByFields(T[] ts, String[] fields) throws DAOException {
        Number[] ids = null;
        Connection con = null;
        if (ts == null || ts.length == 0) {
            return ids;
        }
        ids = new Number[ts.length];
        try {
            Sql[] sqls = SqlFactory.getInsertSql(ts).createByFields(fields);
            int i = 0;
            while (i < ts.length) {
                con = this.ds.getConnection();
                ids[i] = JdbcUtil.updateWithArgs(con, sqls[i].sql, sqls[i].args.toArray());
                ++i;
            }
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return ids;
    }

    @Override
    public <T> Number insertByField(T t, String ... field) throws DAOException {
        Number[] rs = this.insertByFields(new Object[]{t}, field);
        return rs == null ? (Number)0 : (Number)rs[0];
    }

    public DataSource getDs() {
        return this.ds;
    }

    public void setDs(DataSource ds) {
        this.ds = ds;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
}

