/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.config;

import java.io.File;
import org.eweb4j.cache.DBInfoConfigBeanCache;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.CheckConfigBean;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.config.bean.ConfigBean;
import org.eweb4j.config.bean.DBInfoXmlFiles;
import org.eweb4j.orm.dao.config.DAOConfigBeanCreator;
import org.eweb4j.orm.dao.config.bean.DBInfoConfigBean;
import org.eweb4j.orm.jdbc.DataSourceCreator;
import org.eweb4j.orm.jdbc.DataSourceWrap;
import org.eweb4j.orm.jdbc.DataSourceWrapCache;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.FileUtil;
import org.eweb4j.util.xml.BeanXMLUtil;
import org.eweb4j.util.xml.XMLReader;
import org.eweb4j.util.xml.XMLWriter;

public class DAOConfig {
    private static Log log = LogFactory.getORMLogger(DAOConfig.class);

    public static synchronized String check() {
        String error = null;
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        if (cb == null) {
            return null;
        }
        DBInfoXmlFiles dbInfoXmlFiles = cb.getOrm().getDbInfoXmlFiles();
        if (dbInfoXmlFiles == null) {
            return "DAOConfig.class : \u65e0\u6cd5\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6";
        }
        for (String filePath : dbInfoXmlFiles.getPath()) {
            if (filePath == null || filePath.length() == 0) continue;
            File configFile = new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + filePath);
            try {
                XMLReader reader = BeanXMLUtil.getBeanXMLReader(configFile);
                reader.setBeanName("dataSource");
                reader.setClass("dataSource", DBInfoConfigBean.class);
                DBInfoConfigBean dcb = (DBInfoConfigBean)reader.readOne();
                if (dcb == null) {
                    error = DAOConfig.rebuildXmlFile(configFile, "can not read any configuration! now it has bean repaired, please restart.");
                    continue;
                }
                String error1 = CheckConfigBean.checkORMDBInfo(dcb, filePath);
                if (error1 == null) {
                    String error2;
                    if (DBInfoConfigBeanCache.get(dcb.getDsName()) == null) {
                        DBInfoConfigBeanCache.add(dcb.getDsName(), dcb);
                    }
                    DataSourceWrap dsw = null;
                    if (DataSourceWrapCache.containsKey(dcb.getDsName())) {
                        dsw = (DataSourceWrap)DataSourceWrapCache.get(dcb.getDsName());
                        if (dsw == null) {
                            DataSourceWrapCache.remove(dcb.getDsName());
                            log.debug("remove dsName->" + dcb.getDsName());
                        } else {
                            log.debug("DataSource -> " + dcb.getDsName() + " is alive !");
                        }
                    }
                    if (dsw == null) {
                        dsw = new DataSourceWrap(dcb.getDsName(), DataSourceCreator.create(dcb));
                    }
                    String string = error2 = dsw.getConnection() == null ? "can not connect database" : null;
                    if (error2 != null) {
                        if (error == null) {
                            error = error2;
                            continue;
                        }
                        error = String.valueOf(error) + error2;
                        continue;
                    }
                    String info = String.valueOf(dcb.getDsName()) + "." + "start configuration has bean validated and pushed to the cache";
                    log.debug(info);
                    if (DataSourceWrapCache.containsKey(dcb.getDsName())) continue;
                    log.debug("init put ds to cache...");
                    DataSourceWrapCache.put(dcb.getDsName(), dsw);
                    continue;
                }
                if (error == null) {
                    error = error1;
                    continue;
                }
                error = String.valueOf(error) + error1;
            }
            catch (Throwable e) {
                e.printStackTrace();
                error = DAOConfig.rebuildXmlFile(configFile, CommonUtil.getExceptionString(e));
            }
        }
        if (error != null) {
            DBInfoConfigBeanCache.clear();
        }
        return error;
    }

    private static String rebuildXmlFile(File configFile, String err) {
        String error = null;
        try {
            File tf = new File(String.valueOf(configFile.getAbsolutePath()) + ".back" + CommonUtil.getNowTime("_MMddHHmmss"));
            FileUtil.copy(configFile, tf);
            log.debug("backup file->" + tf.getAbsolutePath());
            XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(configFile, (Object)DAOConfigBeanCreator.getDAOBean());
            writer.setBeanName("dataSource");
            writer.setClass("dataSource", DBInfoConfigBean.class);
            writer.write();
            StringBuilder tsb = new StringBuilder("configuration error, now it has bean reparied. exception\uff1a");
            tsb.append(err);
            error = tsb.toString();
            log.error(error);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            StringBuilder sb2 = new StringBuilder("can not write any configuration, exception:");
            sb2.append(CommonUtil.getExceptionString(e1));
            error = sb2.toString();
            log.error(error, e1);
        }
        return error;
    }

    public static void createDBXml(String path, DBInfoConfigBean db) throws Exception {
        XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH()) + path), (Object)db);
        writer.setBeanName("dataSource");
        writer.setClass("dataSource", DBInfoConfigBean.class);
        writer.write();
    }
}

