/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.config;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.orm.annotation.Pk;
import org.eweb4j.orm.config.bean.ORMConfigBean;
import org.eweb4j.orm.config.bean.Property;
import org.eweb4j.util.ReflectUtil;
import org.eweb4j.util.xml.BeanXMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORMConfigBeanWriter {
    public static String write(String filePath, List<Class<?>> list) {
        String error = null;
        if (filePath != null && list != null && !list.isEmpty()) {
            Class[] clss = new Class[list.size()];
            int i = 0;
            while (i < list.size()) {
                clss[i] = list.get(i);
                ++i;
            }
            error = ORMConfigBeanWriter.write(filePath, clss);
        }
        return error;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String write(String filePath, Class<?> ... clazzs) {
        String error = null;
        File file = new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + filePath);
        if (filePath == null) return "Class\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
        if (clazzs == null) return "Class\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
        if (clazzs.length <= 0) return "Class\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
        ArrayList<ORMConfigBean> ormList = new ArrayList<ORMConfigBean>();
        try {
            int i = 0;
            block2: while (true) {
                if (i >= clazzs.length) {
                    BeanXMLUtil.getBeanXMLWriter(file, ormList).write();
                    return error;
                }
                Class<?> clazz = clazzs[i];
                String clsName = clazz.getSimpleName();
                Entity entity = clazz.getAnnotation(Entity.class);
                if (!(entity != null || clsName.endsWith("PO") || clsName.endsWith("POJO") || clsName.endsWith("Entity") || clsName.endsWith("Model"))) {
                    return null;
                }
                Table tableAnn = clazz.getAnnotation(Table.class);
                String table = tableAnn == null ? "" : tableAnn.name();
                table = "".equals(table.trim()) ? clsName : table;
                ORMConfigBean ormBean = new ORMConfigBean();
                ormBean.setClazz(clazz.getName());
                ormBean.setId(clazz.getSimpleName());
                ormBean.setTable(table);
                ReflectUtil ru = new ReflectUtil(clazz);
                ArrayList<Property> pList = new ArrayList<Property>();
                Field[] fieldArray = ru.getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (true) {
                    Id idAnn;
                    if (n2 >= n) {
                        ormBean.setProperty(pList);
                        ormList.add(ormBean);
                        ++i;
                        continue block2;
                    }
                    Field f = fieldArray[n2];
                    String name = f.getName();
                    Method getter = ru.getGetter(name);
                    Column colAnn = getter.getAnnotation(Column.class);
                    if (!(colAnn == null && (colAnn = f.getAnnotation(Column.class)) == null || (idAnn = f.getAnnotation(Id.class)) == null && (idAnn = getter.getAnnotation(Id.class)) == null)) {
                        String column;
                        Property p = new Property();
                        p.setAutoIncrement("1");
                        p.setPk("1");
                        Pk pkAnn = f.getAnnotation(Pk.class);
                        if (pkAnn != null) {
                            p.setPk("1");
                        }
                        column = "".equals((column = colAnn.name()).trim()) ? name : column;
                        p.setName(name);
                        p.setColumn(column);
                        p.setType(f.getType().getName());
                        pList.add(p);
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (Exception e) {
            error = e.getMessage();
            e.printStackTrace();
            return error;
        }
    }

    public static String write(String filePath, String packageName) {
        File[] listFile;
        String error = null;
        ArrayList list = new ArrayList();
        StringBuilder sb = new StringBuilder(ConfigConstant.CONFIG_BASE_PATH);
        sb.append(File.separator).append("classes");
        String[] stringArray = packageName.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            sb.append(File.separator + t);
            ++n2;
        }
        File file = new File(sb.toString());
        File[] fileArray = listFile = file.listFiles();
        int n3 = listFile.length;
        int n4 = 0;
        while (n4 < n3) {
            File f = fileArray[n4];
            if (f.getName().endsWith(".class")) {
                String result = (packageName + "." + f.getName()).substring(0, (packageName + "." + f.getName()).lastIndexOf("."));
                try {
                    list.add(Thread.currentThread().getContextClassLoader().loadClass(result));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ++n4;
        }
        error = ORMConfigBeanWriter.write(filePath, list);
        return error;
    }
}

