/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.view;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.mvc.config.MVCConfigConstant;
import org.eweb4j.mvc.view.Renderer;
import org.eweb4j.util.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerRendererImpl
extends Renderer {
    public Configuration cfg = (Configuration)SingleBeanCache.get("freemarker");

    public FreemarkerRendererImpl() {
        if (this.cfg == null) {
            this.cfg = new Configuration();
            try {
                this.cfg.setDirectoryForTemplateLoading(new File(String.valueOf(ConfigConstant.ROOT_PATH) + MVCConfigConstant.FORWARD_BASE_PATH));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            this.cfg.setDefaultEncoding("UTF-8");
            SingleBeanCache.add("freemarker", this.cfg);
        }
    }

    @Override
    public String render(String name, Object value) {
        return this.render(CommonUtil.map(name, value));
    }

    @Override
    public String render(Map<String, Object> datas) {
        StringWriter writer = new StringWriter();
        this.render(writer, datas);
        return writer.toString();
    }

    @Override
    public String render() {
        return this.render(new HashMap<String, Object>());
    }

    @Override
    public void render(Writer writer) {
        this.render(writer);
    }

    @Override
    public synchronized void render(Writer writer, Map<String, Object> datas) {
        if (datas == null) {
            datas = new HashMap<String, Object>();
        }
        try {
            String tplPath = (String)this.paths.get(MVCConfigConstant.LAYOUT_SCREEN_CONTENT_KEY);
            if (this.layout != null) {
                for (Map.Entry e : this.paths.entrySet()) {
                    String paramName = (String)e.getKey();
                    String path = (String)e.getValue();
                    StringWriter w = new StringWriter();
                    Template template = this.cfg.getTemplate(path);
                    template.setEncoding("UTF-8");
                    template.process(datas, (Writer)w);
                    String screenContent = w.toString();
                    datas.put(paramName, screenContent);
                }
                tplPath = this.layout;
            }
            Template template = this.cfg.getTemplate(tplPath);
            template.setEncoding("UTF-8");
            template.process(datas, writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String render(Map<String, Object> datas, String template) {
        return template;
    }
}

