/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.validator;

import java.util.List;
import java.util.Map;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.action.Validation;
import org.eweb4j.mvc.config.bean.ValidatorConfigBean;
import org.eweb4j.mvc.validator.ValidatorFactory;
import org.eweb4j.mvc.validator.ValidatorIF;

public class ValidateExecution {
    private static Log log = LogFactory.getMVCLogger(ValidateExecution.class);

    public static Validation execute(Context context) {
        Validation validation = new Validation();
        List<ValidatorConfigBean> valList = context.getActionConfigBean().getValidator();
        if (valList == null || valList.isEmpty()) {
            return validation;
        }
        int i = valList.size() - 1;
        while (i > -1) {
            ValidatorConfigBean val = valList.get(i);
            ValidatorIF validator = null;
            if (!"".equals(val.getName()) && (validator = ValidatorFactory.getValidator(val.getName())) == null) {
                try {
                    validator = (ValidatorIF)Thread.currentThread().getContextClassLoader().loadClass(val.getClazz()).newInstance();
                }
                catch (Exception e) {
                    log.error(e.toString(), e);
                }
            }
            if (validator != null) {
                Map<String, Map<String, String>> err = validator.validate(val, context).getErrors();
                for (Map.Entry<String, Map<String, String>> en : err.entrySet()) {
                    String key = en.getKey();
                    Map<String, String> value = en.getValue();
                    if (validation.getErrors().containsKey(key)) {
                        validation.getErrors().get(key).putAll(value);
                        continue;
                    }
                    validation.getErrors().put(key, value);
                }
            }
            --i;
        }
        return validation;
    }
}

