/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.action.Validation;
import org.eweb4j.mvc.config.bean.FieldConfigBean;
import org.eweb4j.mvc.config.bean.ParamConfigBean;
import org.eweb4j.mvc.config.bean.ValidatorConfigBean;
import org.eweb4j.mvc.upload.UploadFile;
import org.eweb4j.mvc.validator.ValidatorIF;
import org.eweb4j.util.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadValidator
implements ValidatorIF {
    @Override
    public Validation validate(ValidatorConfigBean val, Context context) {
        HashMap<String, String> valError = new HashMap<String, String>();
        long countAllSize = 0L;
        block0: for (FieldConfigBean f : val.getField()) {
            String fieldName = f.getName();
            String msg = f.getMessage();
            List<UploadFile> files = context.getUploadMap().get(fieldName);
            if (files == null || files.isEmpty()) continue;
            for (UploadFile file : files) {
                long fileSize;
                String fileName = file.getFileName();
                String fileContentType = file.getContentType();
                String tmpDir = null;
                long memoryMax = 0L;
                String memoryMaxStr = null;
                long allSizeMax = 0L;
                String allSizeMaxStr = null;
                long oneSizeMax = 0L;
                String oneSizeMaxStr = null;
                String[] suffixArray = null;
                for (ParamConfigBean p : f.getParam()) {
                    if ("tmpDir".equalsIgnoreCase(p.getName())) {
                        tmpDir = p.getValue();
                        continue;
                    }
                    if ("maxMemorySize".equalsIgnoreCase(p.getName())) {
                        memoryMax = CommonUtil.strToInt(String.valueOf(CommonUtil.parseFileSize(p.getValue())));
                        memoryMaxStr = p.getValue();
                        continue;
                    }
                    if ("maxRequestSize".equalsIgnoreCase(p.getName())) {
                        allSizeMax = CommonUtil.parseFileSize(p.getValue());
                        allSizeMaxStr = p.getValue();
                        continue;
                    }
                    if ("maxFileSize".equalsIgnoreCase(p.getName())) {
                        oneSizeMax = CommonUtil.parseFileSize(p.getValue());
                        oneSizeMaxStr = p.getValue();
                        continue;
                    }
                    if (!"suffix".equalsIgnoreCase(p.getName())) continue;
                    suffixArray = p.getValue().split(",");
                }
                if (suffixArray != null && suffixArray.length > 0) {
                    boolean isOk = false;
                    String[] stringArray = suffixArray;
                    int n = suffixArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String suffix = stringArray[n2];
                        if (fileName.endsWith("." + suffix)) {
                            isOk = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!isOk) {
                        valError.put(fieldName, this.getParamValue("suffixMsg", f.getParam()).replace("{suffix}", Arrays.asList(suffixArray).toString()));
                        continue block0;
                    }
                }
                if ((fileSize = file.getSize()) > oneSizeMax) {
                    valError.put(fieldName, this.getParamValue("maxFileSizeMsg", f.getParam()).replace("{maxFileSize}", oneSizeMaxStr));
                    continue block0;
                }
                if ((countAllSize += fileSize) <= allSizeMax) continue;
                valError.put(fieldName, this.getParamValue("maxRequestSizeMsg", f.getParam()).replace("{maxRequestSize}", allSizeMaxStr));
                continue block0;
            }
        }
        Validation validation = new Validation();
        if (!valError.isEmpty()) {
            validation.getErrors().put(val.getName(), valError);
        }
        return validation;
    }

    private String getParamValue(String name, List<ParamConfigBean> params) {
        for (ParamConfigBean p : params) {
            if (!name.equals(p.getName())) continue;
            return p.getValue();
        }
        return null;
    }
}

