/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.upload;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.bean.ConfigBean;
import org.eweb4j.config.bean.UploadConfigBean;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.upload.UploadFile;
import org.eweb4j.util.CommonUtil;

public class UploadUtil {
    public static void handleUpload(Context context) throws Exception {
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        UploadConfigBean ucb = cb.getMvc().getUpload();
        String tmpDir = ucb.getTmp();
        int memoryMax = CommonUtil.strToInt(String.valueOf(CommonUtil.parseFileSize(ucb.getMaxMemorySize())));
        long sizeMax = CommonUtil.parseFileSize(ucb.getMaxRequestSize());
        if (tmpDir.trim().length() == 0) {
            tmpDir = "${RootPath}" + File.separator + "WEB-INF" + File.separator + "tmp";
        }
        tmpDir = tmpDir.replace("${RootPath}", ConfigConstant.ROOT_PATH);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(memoryMax);
        factory.setRepository(new File(tmpDir));
        ServletFileUpload _upload = new ServletFileUpload((FileItemFactory)factory);
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)context.getRequest())) {
            return;
        }
        _upload.setSizeMax(sizeMax);
        try {
            List items = _upload.parseRequest(context.getRequest());
            for (FileItem item : items) {
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    String value = item.getString();
                    context.getQueryParamMap().put(fieldName, new String[]{value});
                    continue;
                }
                String fileName = item.getName();
                if (fileName == null || fileName.trim().length() == 0) continue;
                String stamp = CommonUtil.getNowTime("yyyyMMddHHmmss");
                File tmpFile = new File(String.valueOf(tmpDir) + File.separator + stamp + "_" + fileName);
                item.write(tmpFile);
                UploadFile uploadFile = new UploadFile(tmpFile, fileName, fieldName, item.getSize(), item.getContentType());
                if (context.getUploadMap().containsKey(fieldName)) {
                    context.getUploadMap().get(fieldName).add(uploadFile);
                    continue;
                }
                ArrayList<UploadFile> uploads = new ArrayList<UploadFile>();
                uploads.add(uploadFile);
                context.getUploadMap().put(fieldName, uploads);
            }
        }
        catch (FileUploadBase.InvalidContentTypeException e) {
            throw new Exception("upload file error", e);
        }
    }
}

