/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.ioc.config;

import java.io.File;
import java.util.List;
import org.eweb4j.cache.IOCConfigBeanCache;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.CheckConfigBean;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.config.bean.ConfigBean;
import org.eweb4j.ioc.config.IOCConfigBeanCreator;
import org.eweb4j.ioc.config.bean.IOCConfigBean;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.FileUtil;
import org.eweb4j.util.xml.BeanXMLUtil;
import org.eweb4j.util.xml.XMLReader;
import org.eweb4j.util.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOCConfig {
    private static Log log = LogFactory.getIOCLogger(IOCConfig.class);

    public static synchronized String check() {
        String error = null;
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        if (cb == null) {
            return null;
        }
        List<String> iocXmlFilePaths = cb.getIoc().getIocXmlFiles().getPath();
        log.debug("ioc xml files size -> " + iocXmlFilePaths.size());
        for (String filePath : iocXmlFilePaths) {
            if (filePath == null || filePath.length() == 0) continue;
            File configFile = new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + filePath);
            log.debug("check ioc file -> " + configFile.getAbsolutePath());
            try {
                XMLReader reader = BeanXMLUtil.getBeanXMLReader(configFile);
                reader.setBeanName("ioc");
                reader.setClass("ioc", IOCConfigBean.class);
                List<IOCConfigBean> iocList = reader.read();
                if (iocList == null || iocList.isEmpty()) {
                    error = IOCConfig.rebuildXmlFile("can not read any configuration! now it has bean repaired, please restart.", configFile);
                    continue;
                }
                log.debug("read from the ioc file there has ->" + iocList.size() + " beans will be checked ");
                for (IOCConfigBean ioc : iocList) {
                    String error2;
                    String error1 = CheckConfigBean.checkIOC(ioc, filePath);
                    if (error1 != null) {
                        error = error == null ? error1 : String.valueOf(error) + error1;
                    }
                    if ((error2 = CheckConfigBean.checkIOCJnject(ioc.getInject(), iocList, ioc.getId(), filePath)) == null) continue;
                    error = error == null ? error2 : String.valueOf(error) + error2;
                }
                if (error != null) continue;
                for (IOCConfigBean ioc : iocList) {
                    IOCConfigBeanCache.add(ioc.getId(), ioc);
                }
                log.debug(String.valueOf(configFile.getAbsolutePath()) + " beans has checked success ");
            }
            catch (Exception e) {
                e.printStackTrace();
                error = IOCConfig.rebuildXmlFile(String.valueOf(error) + "|" + CommonUtil.getExceptionString(e), configFile);
            }
        }
        if (error != null) {
            IOCConfigBeanCache.clear();
        }
        return error;
    }

    private static String rebuildXmlFile(String error, File configFile) {
        try {
            File tf = new File(String.valueOf(configFile.getAbsolutePath()) + ".back" + CommonUtil.getNowTime("_MMddHHmmss"));
            FileUtil.copy(configFile, tf);
            log.debug("backup file ->" + tf.getAbsolutePath());
            XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(configFile, (Object)IOCConfigBeanCreator.getIOCBean());
            writer.setBeanName("ioc");
            writer.setClass("ioc", IOCConfigBean.class);
            writer.write();
            StringBuilder sb = new StringBuilder("configuration error, now it has bean reparied. exception\uff1a");
            sb.append(error);
            log.error(sb.toString());
        }
        catch (Throwable e1) {
            StringBuilder sb2 = new StringBuilder("can not write any configuration, exception:");
            error = sb2.toString();
            log.error(error, e1);
        }
        return error;
    }

    public static void createIOCXml(String path, List<IOCConfigBean> icbs) throws Exception {
        XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH()) + path), icbs);
        writer.setBeanName("ioc");
        writer.setClass("ioc", IOCConfigBean.class);
        writer.write();
    }
}

