/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.i18n;

import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.config.bean.I18N;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.MVC;

public class Lang {
    private static Log log = LogFactory.getMVCLogger(Lang.class);
    private static ThreadLocal<Locale> current = new ThreadLocal();

    public static Locale get() {
        Locale locale = current.get();
        if (locale == null) {
            Context ctx = MVC.ctx();
            if (ctx != null) {
                HttpServletRequest req = ctx.getRequest();
                HttpServletResponse res = ctx.getResponse();
                if (req != null) {
                    Lang.resolve(req, res);
                } else {
                    Lang.setDefaultLocale();
                }
            } else {
                Lang.setDefaultLocale();
            }
            locale = current.get();
        }
        return locale;
    }

    private static void resolve(HttpServletRequest req, HttpServletResponse res) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                String loc;
                Cookie cookie = cookieArray[n2];
                if ("_EWEB4J_LOCALE".equals(cookie.getName()) && (loc = cookie.getValue()) != null) {
                    String[] locs;
                    if (loc.indexOf("_") > 0 && Lang.set(new Locale((locs = loc.split("_"))[0], locs[1]))) {
                        return;
                    }
                    if (Lang.set(new Locale(loc))) {
                        return;
                    }
                }
                ++n2;
            }
        }
        Locale locale = req.getLocale();
        Lang.set(locale);
        res.addCookie(new Cookie("_EWEB4J_LOCALE", locale.toString()));
    }

    public static boolean set(Locale locale) {
        if (I18N.get().contains(locale)) {
            log.debug("Locale is set -> " + locale.toString());
            current.set(locale);
            return true;
        }
        log.warn("Locale " + locale + " is not defined in your " + ConfigConstant.START_FILE_NAME + " > i18n");
        return false;
    }

    public static void clear() {
        current.remove();
    }

    public static void change(Locale locale) {
        if (Lang.get() == null) {
            if (Lang.set(locale)) {
                MVC.ctx().getResponse().addCookie(new Cookie("_EWEB4J_LOCALE", locale.toString()));
            }
        } else if (!Lang.get().equals(locale) && Lang.set(locale)) {
            MVC.ctx().getResponse().addCookie(new Cookie("_EWEB4J_LOCALE", locale.toString()));
        }
    }

    private static void setDefaultLocale() {
        List<org.eweb4j.config.bean.Locale> locales = I18N.get().getLocale();
        if (locales == null || locales.isEmpty()) {
            Lang.set(Locale.getDefault());
        } else {
            Lang.set(new Locale(locales.get(0).getLanguage(), locales.get(0).getCountry()));
        }
    }
}

