/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;

public class DenseMatrixBool
implements ReshapeMatrix {
    public boolean[] data;
    public int numRows;
    public int numCols;

    public DenseMatrixBool(int numRows, int numCols) {
        this.data = new boolean[numRows * numCols];
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    public int getIndex(int row, int col) {
        return row * this.numCols + col;
    }

    public boolean get(int index) {
        return this.data[index];
    }

    public boolean get(int row, int col) {
        if (!this.isInBounds(row, col)) {
            throw new IllegalArgumentException("Out of matrix bounds. " + row + " " + col);
        }
        return this.data[row * this.numCols + col];
    }

    public void set(int row, int col, boolean value) {
        if (!this.isInBounds(row, col)) {
            throw new IllegalArgumentException("Out of matrix bounds. " + row + " " + col);
        }
        this.data[row * this.numCols + col] = value;
    }

    public boolean unsafe_get(int row, int col) {
        return this.data[row * this.numCols + col];
    }

    public void unsafe_set(int row, int col, boolean value) {
        this.data[row * this.numCols + col] = value;
    }

    public boolean isInBounds(int row, int col) {
        return col >= 0 && col < this.numCols && row >= 0 && row < this.numRows;
    }

    @Override
    public void reshape(int numRows, int numCols) {
        int N = numRows * numCols;
        if (this.data.length < N) {
            this.data = new boolean[N];
        }
        this.numRows = numRows;
        this.numCols = numCols;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    public <T extends Matrix> T copy() {
        DenseMatrixBool ret = new DenseMatrixBool(this.numRows, this.numCols);
        ret.set(this);
        return (T)ret;
    }

    @Override
    public void set(Matrix original) {
        DenseMatrixBool orig = (DenseMatrixBool)original;
        this.reshape(original.getNumRows(), original.getNumCols());
        System.arraycopy(orig.data, 0, this.data, 0, orig.getNumElements());
    }

    @Override
    public void print() {
        System.out.println("Implement this");
    }
}

