/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.basic;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.statistics.StatsUtils;
import org.ehcache.impl.internal.util.CheckerUtil;
import org.terracotta.statistics.MappedOperationStatistic;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.ZeroOperationStatistic;
import org.terracotta.statistics.observer.OperationObserver;

public abstract class BaseStore<K, V>
implements Store<K, V> {
    protected final Class<K> keyType;
    protected final Class<V> valueType;
    protected final boolean operationStatisticsEnabled;

    public BaseStore(Store.Configuration<K, V> config) {
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.operationStatisticsEnabled = config.isOperationStatisticsEnabled();
    }

    protected void checkKey(K keyObject) {
        CheckerUtil.checkKey(this.keyType, keyObject);
    }

    protected void checkValue(V valueObject) {
        CheckerUtil.checkValue(this.valueType, valueObject);
    }

    protected <T extends Enum<T>> OperationObserver<T> createObserver(String name, Class<T> outcome, boolean canBeDisabled) {
        if (!this.operationStatisticsEnabled && canBeDisabled) {
            return ZeroOperationStatistic.get();
        }
        return ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(outcome).named(name)).of(this)).tag(this.getStatisticsTag())).build();
    }

    protected <T extends Serializable> void registerStatistic(String name, StatisticType type, Set<String> tags, Supplier<T> valueSupplier) {
        StatisticsManager.createPassThroughStatistic((Object)this, name, tags, type, valueSupplier);
    }

    protected abstract String getStatisticsTag();

    protected static abstract class BaseStoreProvider
    implements Store.Provider {
        protected BaseStoreProvider() {
        }

        protected <K, V, S extends Enum<S>, T extends Enum<T>> OperationStatistic<T> createTranslatedStatistic(BaseStore<K, V> store, String statisticName, Map<T, Set<S>> translation, String targetName) {
            Class<S> outcomeType = BaseStoreProvider.getOutcomeType(translation);
            if (StatsUtils.hasOperationStat(store, outcomeType, targetName)) {
                int tierHeight = this.getResourceType().getTierHeight();
                MappedOperationStatistic<S, T> stat = new MappedOperationStatistic<S, T>(store, translation, statisticName, tierHeight, targetName, store.getStatisticsTag());
                StatisticsManager.associate(stat).withParent(store);
                return stat;
            }
            return ZeroOperationStatistic.get();
        }

        private static <S extends Enum<S>, T extends Enum<T>> Class<S> getOutcomeType(Map<T, Set<S>> translation) {
            Map.Entry<T, Set<S>> first = translation.entrySet().iterator().next();
            Class outcomeType = ((Enum)first.getValue().iterator().next()).getDeclaringClass();
            return outcomeType;
        }

        protected abstract ResourceType<?> getResourceType();
    }
}

