/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;

public class LimitIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private final long limit;
    private long returnCount;

    public LimitIteration(Iteration<? extends E, X> iter, long limit) {
        super(iter);
        assert (iter != null);
        assert (limit >= 0L);
        this.limit = limit;
        this.returnCount = 0L;
    }

    @Override
    public boolean hasNext() throws X {
        return this.returnCount < this.limit && super.hasNext();
    }

    @Override
    public E next() throws X {
        if (this.returnCount >= this.limit) {
            throw new NoSuchElementException("limit reached");
        }
        ++this.returnCount;
        return super.next();
    }
}

