/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;

public abstract class FilterIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private E nextElement;

    public FilterIteration(Iteration<? extends E, ? extends X> iter) {
        super(iter);
    }

    @Override
    public boolean hasNext() throws X {
        this.findNextElement();
        return this.nextElement != null;
    }

    @Override
    public E next() throws X {
        this.findNextElement();
        E result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNextElement() throws X {
        while (this.nextElement == null && super.hasNext()) {
            Object candidate = super.next();
            if (!this.accept(candidate)) continue;
            this.nextElement = candidate;
        }
    }

    protected abstract boolean accept(E var1) throws X;

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        this.nextElement = null;
    }
}

