/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import java.util.List;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.FunctionParser;
import org.eclipse.rdf4j.spin.function.TransientFunction;

public class SpinTupleFunctionAsFunctionParser
implements FunctionParser {
    private final SpinParser parser;

    public SpinTupleFunctionAsFunctionParser(SpinParser parser) {
        this.parser = parser;
    }

    @Override
    public Function parse(IRI funcUri, TripleSource store) throws RDF4JException {
        Statement magicPropStmt = TripleSources.single((Resource)funcUri, RDF.TYPE, (Value)SPIN.MAGIC_PROPERTY_CLASS, store);
        if (magicPropStmt == null) {
            return null;
        }
        Value body = TripleSources.singleValue((Resource)funcUri, SPIN.BODY_PROPERTY, store);
        if (!(body instanceof Resource)) {
            return null;
        }
        final TupleFunction tupleFunc = this.parser.parseMagicProperty(funcUri, store);
        return new TransientFunction(){

            @Override
            public String getURI() {
                return tupleFunc.getURI();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
                try (CloseableIteration<? extends List<? extends Value>, QueryEvaluationException> iter = tupleFunc.evaluate(valueFactory, args);){
                    if (iter.hasNext()) {
                        Value value = (Value)((List)iter.next()).get(0);
                        return value;
                    }
                    Value value = null;
                    return value;
                }
                catch (QueryEvaluationException e) {
                    throw new ValueExprEvaluationException(e);
                }
            }
        };
    }
}

