/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryRegistry;
import org.eclipse.rdf4j.repository.event.NotifyingRepositoryConnection;
import org.eclipse.rdf4j.repository.event.base.NotifyingRepositoryWrapper;
import org.eclipse.rdf4j.repository.manager.SystemRepositoryConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SystemRepository
extends NotifyingRepositoryWrapper {
    private static final String CONFIG_SYSTEM_TTL = "org/eclipse/rdf4j/repository/config/system.ttl";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String ID = "SYSTEM";
    public static final String TITLE = "System configuration repository";
    public static final String REPOSITORY_TYPE = "openrdf:SystemRepository";

    public SystemRepository(File systemDir) throws RepositoryException {
        super.setDelegate(this.createDelegate());
        this.setDataDir(systemDir);
    }

    SystemRepository() throws RepositoryException {
        super.setDelegate(this.createDelegate());
    }

    private Repository createDelegate() {
        RepositoryConfig repoConfig = this.getSystemConfig();
        if (repoConfig == null) {
            throw new RepositoryConfigException("Could not find SYSTEM configuration");
        }
        repoConfig.validate();
        RepositoryImplConfig config = repoConfig.getRepositoryImplConfig();
        RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get((Object)config.getType()).orElseThrow(() -> new RepositoryConfigException("Repository type not in classpath: " + config.getType()));
        return factory.getRepository(config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RepositoryConfig getSystemConfig() {
        URL ttl = ((Object)((Object)this)).getClass().getClassLoader().getResource(CONFIG_SYSTEM_TTL);
        if (ttl == null) {
            return null;
        }
        try (InputStream in = ttl.openStream();){
            Model model = Rio.parse((InputStream)in, (String)ttl.toString(), (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
            RepositoryConfig repositoryConfig = RepositoryConfigUtil.getRepositoryConfig((Model)model, (String)ID);
            return repositoryConfig;
        }
        catch (IOException e) {
            throw new RepositoryConfigException((Throwable)e);
        }
    }

    public void initialize() throws RepositoryException {
        super.initialize();
        try (NotifyingRepositoryConnection con = this.getConnection();){
            if (con.isEmpty()) {
                this.logger.debug("Initializing empty {} repository", (Object)ID);
                con.begin();
                con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                con.setNamespace("sys", "http://www.openrdf.org/config/repository#");
                con.commit();
                RepositoryConfig repConfig = new RepositoryConfig(ID, TITLE, (RepositoryImplConfig)new SystemRepositoryConfig());
                RepositoryConfigUtil.updateRepositoryConfigs((RepositoryConnection)con, (RepositoryConfig[])new RepositoryConfig[]{repConfig});
            }
        }
    }

    public void setDelegate(Repository delegate) {
        throw new UnsupportedOperationException("Setting delegate on system repository not allowed");
    }
}

