/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.IOException;
import org.eclipse.rdf4j.console.Close;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.LockRemover;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryLockedException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Open
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Open.class);
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final Close close;
    private final LockRemover lockRemover;
    private static final String OPEN_FAILURE = "Failed to open repository";

    Open(ConsoleIO consoleIO, ConsoleState state, Close close, LockRemover lockRemover) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.close = close;
        this.lockRemover = lockRemover;
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length == 2) {
            this.openRepository(tokens[1]);
        } else {
            this.consoleIO.writeln("Usage:\nopen <repositoryID>   Opens the repository with the specified ID\n");
        }
    }

    protected void openRepository(String repoID) {
        try {
            Repository newRepository = this.state.getManager().getRepository(repoID);
            if (newRepository == null) {
                this.consoleIO.writeError("Unknown repository: '" + repoID + "'");
            } else {
                this.close.closeRepository(false);
                this.state.setRepository(newRepository);
                this.state.setRepositoryID(repoID);
                this.consoleIO.writeln("Opened repository '" + repoID + "'");
            }
        }
        catch (RepositoryLockedException e) {
            try {
                if (this.lockRemover.tryToRemoveLock(e)) {
                    this.openRepository(repoID);
                }
                this.consoleIO.writeError(OPEN_FAILURE);
                LOGGER.error(OPEN_FAILURE, (Throwable)e);
            }
            catch (IOException e1) {
                this.consoleIO.writeError("Unable to remove lock: " + e1.getMessage());
            }
        }
        catch (RepositoryConfigException e) {
            this.consoleIO.writeError(e.getMessage());
            LOGGER.error(OPEN_FAILURE, (Throwable)e);
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError(e.getMessage());
            LOGGER.error(OPEN_FAILURE, (Throwable)e);
        }
    }
}

