/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.repository.Repository;

public class Close
implements Command {
    private final ConsoleIO consoleIO;
    private final ConsoleState appInfo;

    Close(ConsoleIO consoleIO, ConsoleState appInfo) {
        this.consoleIO = consoleIO;
        this.appInfo = appInfo;
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length == 1) {
            this.closeRepository(true);
        } else {
            this.consoleIO.writeln("Usage:\nclose   Closes the current repository\n");
        }
    }

    protected void closeRepository(boolean verbose) {
        Repository repository = this.appInfo.getRepository();
        if (repository == null) {
            if (verbose) {
                this.consoleIO.writeln("There are no open repositories that can be closed");
            }
        } else {
            this.consoleIO.writeln("Closing repository '" + this.appInfo.getRepositoryID() + "'...");
            this.appInfo.setRepository(null);
            this.appInfo.setRepositoryID(null);
        }
    }
}

