/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.platform;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessLauncher {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String commandLine;
    private String[] commandArray;
    private final File baseDir;
    private final List<OutputListener> listeners = new ArrayList<OutputListener>(1);
    private volatile Process subProcess;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final StringBuilder out = new StringBuilder();
    private final StringBuilder err = new StringBuilder();

    public ProcessLauncher(String commandLine) {
        this(commandLine, null);
    }

    public ProcessLauncher(String commandLine, File baseDir) {
        this.commandLine = commandLine;
        this.baseDir = baseDir;
    }

    public ProcessLauncher(String[] commandArray) {
        this(commandArray, null);
    }

    public ProcessLauncher(String[] commandArray, File baseDir) {
        this.commandArray = commandArray;
        this.baseDir = baseDir;
    }

    public ProcessLauncher(ArrayList<?> commandList) {
        this(commandList, null);
    }

    public ProcessLauncher(ArrayList<?> commandList, File baseDir) {
        this(ProcessLauncher.toStringArray(commandList), baseDir);
    }

    private static <T> String[] toStringArray(ArrayList<T> list) {
        String[] result = new String[list.size()];
        Iterator<T> iter = list.iterator();
        int arrayIndex = 0;
        while (iter.hasNext()) {
            result[arrayIndex++] = iter.next().toString();
        }
        return result;
    }

    public void addOutputListener(OutputListener listener) {
        this.listeners.add(listener);
    }

    private void fireErr(char[] err) {
        if (this.listeners.isEmpty()) {
            this.err.append((CharSequence)this.out);
        }
        Iterator<OutputListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().errorOutput(err);
        }
    }

    private void fireOut(char[] out) {
        if (this.listeners.isEmpty()) {
            this.out.append(out);
        }
        Iterator<OutputListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().standardOutput(out);
        }
    }

    public String getStandardOutput() {
        if (!this.listeners.isEmpty()) {
            throw new IllegalStateException("Cannot get standard output, because outputlisteners have been registered.");
        }
        return this.out.toString();
    }

    public String getErrorOutput() {
        if (!this.listeners.isEmpty()) {
            throw new IllegalStateException("Cannot get error output, because outputlisteners have been registered.");
        }
        return this.err.toString();
    }

    public String getCommandLine() {
        if (this.commandLine != null) {
            return this.commandLine;
        }
        if (this.commandArray != null) {
            StringBuilder result = new StringBuilder(64);
            for (int i = 0; i < this.commandArray.length; ++i) {
                if (i > 0) {
                    result.append(' ');
                }
                result.append(this.commandArray[i]);
            }
            return result.toString();
        }
        return null;
    }

    public boolean hasFinished() {
        return this.finished.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int launch() throws CommandNotExistsException {
        int n;
        this.err.setLength(0);
        this.out.setLength(0);
        BackgroundPrinter stdout = null;
        BackgroundPrinter stderr = null;
        Process nextSubProcess = this.subProcess;
        try {
            nextSubProcess = this.commandArray != null ? (this.subProcess = Runtime.getRuntime().exec(this.commandArray, null, this.baseDir)) : (this.subProcess = Runtime.getRuntime().exec(this.commandLine, null, this.baseDir));
            stdout = new BackgroundPrinter(nextSubProcess.getInputStream(), false);
            stderr = new BackgroundPrinter(nextSubProcess.getErrorStream(), true);
            stdout.start();
            stderr.start();
            int exitValue = nextSubProcess.waitFor();
            stdout.join(10000L);
            stderr.join(10000L);
            if (exitValue != 0) {
                this.logger.info("WARNING: exit value " + exitValue + " for command \"" + this.getCommandLine() + "\"");
            }
            n = exitValue;
        }
        catch (Throwable throwable) {
            try {
                try {
                    this.subProcess = null;
                    if (nextSubProcess != null) {
                        nextSubProcess.destroy();
                    }
                }
                finally {
                    try {
                        if (stdout != null) {
                            stdout.close();
                        }
                    }
                    finally {
                        try {
                            if (stderr != null) {
                                stderr.close();
                            }
                        }
                        finally {
                            this.finished.set(true);
                        }
                    }
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new CommandNotExistsException("Command probably does not exist: " + ioe);
            }
            catch (Exception e) {
                this.logger.error("Exception while running/launching \"" + this.getCommandLine() + "\".", (Throwable)e);
                return -1;
            }
        }
        try {
            this.subProcess = null;
            if (nextSubProcess != null) {
                nextSubProcess.destroy();
            }
        }
        finally {
            try {
                if (stdout != null) {
                    stdout.close();
                }
            }
            finally {
                try {
                    if (stderr != null) {
                        stderr.close();
                    }
                }
                finally {
                    this.finished.set(true);
                }
            }
        }
        return n;
    }

    public void abort() {
        Process nextSubProcess = this.subProcess;
        this.subProcess = null;
        if (nextSubProcess != null) {
            nextSubProcess.destroy();
        }
    }

    public static class CommandNotExistsException
    extends RuntimeException {
        private static final long serialVersionUID = -3770613178610919742L;

        public CommandNotExistsException(String msg) {
            super(msg);
        }
    }

    private class BackgroundPrinter
    extends Thread
    implements Closeable {
        private InputStream in;
        boolean isErrorOutput;

        public BackgroundPrinter(InputStream in, boolean isErrorOutput) {
            this.in = in;
            this.isErrorOutput = isErrorOutput;
        }

        @Override
        public void run() {
            try {
                int numberOfReadBytes;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
                char[] buf = new char[1024];
                while ((numberOfReadBytes = reader.read(buf)) != -1) {
                    char[] clearedbuf = new char[numberOfReadBytes];
                    System.arraycopy(buf, 0, clearedbuf, 0, numberOfReadBytes);
                    if (this.isErrorOutput) {
                        ProcessLauncher.this.fireErr(clearedbuf);
                        continue;
                    }
                    ProcessLauncher.this.fireOut(clearedbuf);
                }
            }
            catch (Exception e) {
                ProcessLauncher.this.logger.warn("Exception while reading from stream from subprocess.", (Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.in.close();
            }
            catch (Exception e) {
                ProcessLauncher.this.logger.warn("Closing background stream for launched process caused exception.", (Throwable)e);
            }
        }
    }

    public static interface OutputListener {
        public void standardOutput(char[] var1);

        public void errorOutput(char[] var1);
    }
}

