/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ntriples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;

public class NTriplesWriter
extends AbstractRDFWriter
implements RDFWriter {
    protected final Writer writer;
    protected boolean writingStarted;
    private boolean xsdStringToPlainLiteral = true;
    private boolean escapeUnicode;

    public NTriplesWriter(OutputStream out) {
        this(new OutputStreamWriter(out, Charset.forName("UTF-8")));
    }

    public NTriplesWriter(Writer writer) {
        this.writer = writer;
        this.writingStarted = false;
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this.writingStarted = true;
        this.xsdStringToPlainLiteral = this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        this.escapeUnicode = this.getWriterConfig().get(NTriplesWriterSettings.ESCAPE_UNICODE);
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
        finally {
            this.writingStarted = false;
        }
    }

    @Override
    public void handleNamespace(String prefix, String name) {
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            this.writeValue(st.getSubject());
            this.writer.write(" ");
            this.writeIRI(st.getPredicate());
            this.writer.write(" ");
            this.writeValue(st.getObject());
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public final Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        result.add(NTriplesWriterSettings.ESCAPE_UNICODE);
        return result;
    }

    protected void writeValue(Value value) throws IOException {
        if (value instanceof IRI) {
            this.writeIRI((IRI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass());
        }
    }

    private void writeIRI(IRI iri) throws IOException {
        NTriplesUtil.append(iri, (Appendable)this.writer);
    }

    private void writeBNode(BNode bNode) throws IOException {
        String nextId = bNode.getID();
        this.writer.append("_:");
        if (nextId.isEmpty()) {
            this.writer.append("genid");
            this.writer.append(Integer.toHexString(bNode.hashCode()));
        } else {
            if (!NTriplesUtil.isLetter(nextId.charAt(0))) {
                this.writer.append("genid");
                this.writer.append(Integer.toHexString(nextId.charAt(0)));
            }
            for (int i = 0; i < nextId.length(); ++i) {
                if (NTriplesUtil.isLetterOrNumber(nextId.charAt(i))) {
                    this.writer.append(nextId.charAt(i));
                    continue;
                }
                this.writer.append(Integer.toHexString(nextId.charAt(i)));
            }
        }
    }

    private void writeLiteral(Literal lit) throws IOException {
        this.writer.append("\"");
        this.writeString(lit.getLabel());
        this.writer.append("\"");
        if (Literals.isLanguageLiteral(lit)) {
            this.writer.append("@");
            this.writer.append(lit.getLanguage().get());
        } else {
            IRI datatype = lit.getDatatype();
            if (!datatype.equals(XMLSchema.STRING) || !this.xsdStringToPlainLiteral) {
                this.writer.append("^^");
                this.writeIRI(lit.getDatatype());
            }
        }
    }

    private void writeString(String label) throws IOException {
        NTriplesUtil.escapeString(label, this.writer, this.escapeUnicode);
    }
}

