/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.eclipse.rdf4j.repository.http.HTTPRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;

public class HTTPRepository
extends AbstractRepository
implements HttpClientDependent,
SessionManagerDependent {
    private volatile HttpClientSessionManager client;
    private volatile SharedHttpClientSessionManager dependentClient;
    private String username;
    private String password;
    private String serverURL;
    private String repositoryURL;
    private RDFFormat rdfFormat;
    private TupleQueryResultFormat tupleFormat;
    private File dataDir;
    private volatile Boolean compatibleMode = null;

    private HTTPRepository() {
    }

    public HTTPRepository(String serverURL, String repositoryID) {
        this();
        this.serverURL = serverURL;
        this.repositoryURL = Protocol.getRepositoryLocation(serverURL, repositoryID);
    }

    public HTTPRepository(String repositoryURL) {
        this();
        Pattern urlPattern = Pattern.compile("(.*)/repositories/[^/]*/?");
        Matcher matcher = urlPattern.matcher(repositoryURL);
        if (!matcher.matches() || matcher.groupCount() != 1) {
            throw new IllegalArgumentException("URL must be to a Sesame Repository (not just the server)");
        }
        this.serverURL = matcher.group(1);
        this.repositoryURL = repositoryURL;
    }

    @Override
    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientSessionManager getHttpClientSessionManager() {
        HttpClientSessionManager result = this.client;
        if (result == null) {
            HTTPRepository hTTPRepository = this;
            synchronized (hTTPRepository) {
                result = this.client;
                if (result == null) {
                    this.dependentClient = new SharedHttpClientSessionManager();
                    this.client = this.dependentClient;
                    result = this.dependentClient;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        HTTPRepository hTTPRepository = this;
        synchronized (hTTPRepository) {
            this.client = client;
            SharedHttpClientSessionManager toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                toCloseDependentClient.shutDown();
            }
        }
    }

    @Override
    public final HttpClient getHttpClient() {
        return this.getHttpClientSessionManager().getHttpClient();
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        SharedHttpClientSessionManager toSetDependentClient = this.dependentClient;
        if (toSetDependentClient == null) {
            this.getHttpClientSessionManager();
            toSetDependentClient = this.dependentClient;
        }
        if (toSetDependentClient != null) {
            toSetDependentClient.setHttpClient(httpClient);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    @Override
    public RepositoryConnection getConnection() throws RepositoryException {
        return new HTTPRepositoryConnection(this, this.createHTTPClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWritable() throws RepositoryException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("HTTPRepository not initialized.");
        }
        boolean isWritable = false;
        try (RDF4JProtocolSession client = this.createHTTPClient();){
            String repositoryURL = client.getRepositoryURL();
            try (TupleQueryResult repositoryList = client.getRepositoryList();){
                while (repositoryList.hasNext()) {
                    BindingSet bindingSet = (BindingSet)repositoryList.next();
                    Value uri = bindingSet.getValue("uri");
                    if (uri == null || !uri.stringValue().equals(repositoryURL)) continue;
                    isWritable = Literals.getBooleanValue(bindingSet.getValue("writable"), false);
                    break;
                }
            }
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        return isWritable;
    }

    public void setPreferredTupleQueryResultFormat(TupleQueryResultFormat format) {
        this.tupleFormat = format;
    }

    public TupleQueryResultFormat getPreferredTupleQueryResultFormat() {
        return this.tupleFormat;
    }

    public void setPreferredRDFFormat(RDFFormat format) {
        this.rdfFormat = format;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.rdfFormat;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    @Override
    protected void initializeInternal() throws RepositoryException {
    }

    @Override
    protected void shutDownInternal() throws RepositoryException {
        try {
            SharedHttpClientSessionManager toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                toCloseDependentClient.shutDown();
            }
        }
        finally {
            this.client = null;
        }
    }

    protected RDF4JProtocolSession createHTTPClient() {
        RDF4JProtocolSession httpClient = this.getHttpClientSessionManager().createRDF4JProtocolSession(this.serverURL);
        httpClient.setValueFactory(SimpleValueFactory.getInstance());
        if (this.repositoryURL != null) {
            httpClient.setRepository(this.repositoryURL);
        }
        if (this.tupleFormat != null) {
            httpClient.setPreferredTupleQueryResultFormat(this.tupleFormat);
        }
        if (this.rdfFormat != null) {
            httpClient.setPreferredRDFFormat(this.rdfFormat);
        }
        if (this.username != null) {
            httpClient.setUsernameAndPassword(this.username, this.password);
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useCompatibleMode() throws RepositoryException {
        Boolean result = this.compatibleMode;
        if (result == null) {
            HTTPRepository hTTPRepository = this;
            synchronized (hTTPRepository) {
                result = this.compatibleMode;
                if (result == null) {
                    try (RDF4JProtocolSession client = this.createHTTPClient();){
                        String serverProtocolVersion = client.getServerProtocol();
                        result = this.compatibleMode = Boolean.valueOf(Integer.parseInt(serverProtocolVersion) < 7);
                    }
                    catch (NumberFormatException e) {
                        throw new RepositoryException("could not read protocol version from server: ", e);
                    }
                    catch (IOException e) {
                        throw new RepositoryException("could not read protocol version from server: ", e);
                    }
                }
            }
        }
        return result;
    }
}

