/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqljson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSPARQLJSONParser
extends AbstractQueryResultParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    public static final String HEAD = "head";
    public static final String LINK = "link";
    public static final String VARS = "vars";
    public static final String BOOLEAN = "boolean";
    public static final String RESULTS = "results";
    public static final String BINDINGS = "bindings";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String XMLLANG = "xml:lang";
    public static final String DATATYPE = "datatype";
    public static final String LITERAL = "literal";
    public static final String TYPED_LITERAL = "typed-literal";
    public static final String BNODE = "bnode";
    public static final String URI = "uri";
    private static final String DISTINCT = "distinct";
    private static final String ORDERED = "ordered";

    public AbstractSPARQLJSONParser() {
    }

    public AbstractSPARQLJSONParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public void parseQueryResult(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        this.parseQueryResultInternal(in, true, true);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean parseQueryResultInternal(InputStream in, boolean attemptParseBoolean, boolean attemptParseTuple) throws IOException, QueryResultParseException, QueryResultHandlerException {
        if (!attemptParseBoolean && !attemptParseTuple) {
            throw new IllegalArgumentException("Internal error: Did not specify whether to parse as either boolean and/or tuple");
        }
        JsonParser jp = JSON_FACTORY.createParser(in);
        boolean result = false;
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new QueryResultParseException("Expected SPARQL Results JSON document to start with an Object", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
        ArrayList<String> varsList = new ArrayList<String>();
        boolean varsFound = false;
        HashSet<MapBindingSet> bindings = new HashSet<MapBindingSet>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String baseStr = jp.getCurrentName();
            if (baseStr.equals(HEAD)) {
                if (jp.nextToken() != JsonToken.START_OBJECT) {
                    throw new QueryResultParseException("Did not find object under " + baseStr + " field", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                }
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    String headStr = jp.getCurrentName();
                    if (headStr.equals(VARS)) {
                        if (!attemptParseTuple) {
                            throw new QueryResultParseException("Found tuple results variables when attempting to parse SPARQL Results JSON to boolean result");
                        }
                        if (jp.nextToken() != JsonToken.START_ARRAY) {
                            throw new QueryResultParseException("Expected variable labels to be an array", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                        }
                        while (jp.nextToken() != JsonToken.END_ARRAY) {
                            varsList.add(jp.getText());
                        }
                        if (this.handler != null) {
                            this.handler.startQueryResult(varsList);
                        }
                        varsFound = true;
                        if (bindings.isEmpty() || this.handler == null) continue;
                        for (BindingSet bindingSet : bindings) {
                            this.handler.handleSolution(bindingSet);
                            this.handler.endQueryResult();
                        }
                        bindings.clear();
                        continue;
                    }
                    if (headStr.equals(LINK)) {
                        ArrayList<String> linksList = new ArrayList<String>();
                        if (jp.nextToken() != JsonToken.START_ARRAY) {
                            throw new QueryResultParseException("Expected links to be an array", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                        }
                        while (jp.nextToken() != JsonToken.END_ARRAY) {
                            linksList.add(jp.getText());
                        }
                        if (this.handler == null) continue;
                        this.handler.handleLinks(linksList);
                        continue;
                    }
                    throw new QueryResultParseException("Found unexpected object in head field: " + headStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                }
                continue;
            }
            if (baseStr.equals(RESULTS)) {
                if (!attemptParseTuple) {
                    throw new QueryResultParseException("Found tuple results bindings when attempting to parse SPARQL Results JSON to boolean result");
                }
                if (jp.nextToken() != JsonToken.START_OBJECT) {
                    throw new QueryResultParseException("Found unexpected token in results object: " + jp.getCurrentName(), (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                }
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    if (jp.getCurrentName().equals(BINDINGS)) {
                        if (jp.nextToken() != JsonToken.START_ARRAY) {
                            throw new QueryResultParseException("Found unexpected token in bindings object", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                        }
                        while (jp.nextToken() != JsonToken.END_ARRAY) {
                            MapBindingSet nextBindingSet = new MapBindingSet();
                            if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                                throw new QueryResultParseException("Did not find object in bindings array: " + jp.getCurrentName(), (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_OBJECT) {
                                void var12_15;
                                if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                    throw new QueryResultParseException("Did not find binding name", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                }
                                String bindingStr = jp.getCurrentName();
                                if (jp.nextToken() != JsonToken.START_OBJECT) {
                                    throw new QueryResultParseException("Did not find object for binding value", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                }
                                Object var12_14 = null;
                                String type = null;
                                String datatype = null;
                                String value = null;
                                while (jp.nextToken() != JsonToken.END_OBJECT) {
                                    if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                        throw new QueryResultParseException("Did not find value attribute under " + bindingStr + " field", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                    }
                                    String fieldName = jp.getCurrentName();
                                    jp.nextToken();
                                    if (TYPE.equals(fieldName)) {
                                        type = jp.getText();
                                        continue;
                                    }
                                    if (XMLLANG.equals(fieldName)) {
                                        String string = jp.getText();
                                        continue;
                                    }
                                    if (DATATYPE.equals(fieldName)) {
                                        datatype = jp.getText();
                                        continue;
                                    }
                                    if (VALUE.equals(fieldName)) {
                                        value = jp.getText();
                                        continue;
                                    }
                                    throw new QueryResultParseException("Unexpected field name: " + fieldName, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                }
                                nextBindingSet.addBinding(bindingStr, this.parseValue(type, value, (String)var12_15, datatype));
                            }
                            if (!varsFound) {
                                bindings.add(nextBindingSet);
                                continue;
                            }
                            if (this.handler == null) continue;
                            this.handler.handleSolution(nextBindingSet);
                        }
                        if (this.handler == null) continue;
                        this.handler.endQueryResult();
                        continue;
                    }
                    if (jp.getCurrentName().equals(DISTINCT) || jp.getCurrentName().equals(ORDERED)) {
                        jp.nextToken();
                        continue;
                    }
                    throw new QueryResultParseException("Found unexpected field in results: " + jp.getCurrentName(), (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                }
                continue;
            }
            if (baseStr.equals(BOOLEAN)) {
                if (!attemptParseBoolean) {
                    throw new QueryResultParseException("Found boolean results when attempting to parse SPARQL Results JSON to tuple results");
                }
                jp.nextToken();
                result = Boolean.parseBoolean(jp.getText());
                if (this.handler == null) continue;
                this.handler.handleBoolean(result);
                continue;
            }
            this.logger.debug("Found unexpected object in top level {} field #{}.{}", new Object[]{baseStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr()});
        }
        return result;
    }

    private Value parseValue(String type, String value, String language, String datatype) {
        this.logger.trace("type: {}", (Object)type);
        this.logger.trace("value: {}", (Object)value);
        this.logger.trace("language: {}", (Object)language);
        this.logger.trace("datatype: {}", (Object)datatype);
        Value result = null;
        if (type.equals(LITERAL) || type.equals(TYPED_LITERAL)) {
            result = language != null ? this.valueFactory.createLiteral(value, language) : (datatype != null ? this.valueFactory.createLiteral(value, this.valueFactory.createIRI(datatype)) : this.valueFactory.createLiteral(value));
        } else if (type.equals(BNODE)) {
            result = this.valueFactory.createBNode(value);
        } else if (type.equals(URI)) {
            result = this.valueFactory.createIRI(value);
        }
        this.logger.debug("result value: {}", (Object)result);
        return result;
    }

    static {
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }
}

