/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public abstract class BinaryTupleOperator
extends AbstractQueryModelNode
implements TupleExpr {
    protected TupleExpr leftArg;
    protected TupleExpr rightArg;

    public BinaryTupleOperator() {
    }

    public BinaryTupleOperator(TupleExpr leftArg, TupleExpr rightArg) {
        this.setLeftArg(leftArg);
        this.setRightArg(rightArg);
    }

    public TupleExpr getLeftArg() {
        return this.leftArg;
    }

    public void setLeftArg(TupleExpr leftArg) {
        assert (leftArg != null) : "leftArg must not be null";
        assert (leftArg != this) : "leftArg must not be itself";
        leftArg.setParentNode(this);
        this.leftArg = leftArg;
    }

    public TupleExpr getRightArg() {
        return this.rightArg;
    }

    public void setRightArg(TupleExpr rightArg) {
        assert (rightArg != null) : "rightArg must not be null";
        assert (rightArg != this) : "rightArg must not be itself";
        rightArg.setParentNode(this);
        this.rightArg = rightArg;
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.leftArg.visit(visitor);
        this.rightArg.visit(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.leftArg == current) {
            this.setLeftArg((TupleExpr)replacement);
        } else if (this.rightArg == current) {
            this.setRightArg((TupleExpr)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BinaryTupleOperator) {
            BinaryTupleOperator o = (BinaryTupleOperator)other;
            return this.leftArg.equals(o.getLeftArg()) && this.rightArg.equals(o.getRightArg());
        }
        return false;
    }

    public int hashCode() {
        return this.leftArg.hashCode() ^ this.rightArg.hashCode();
    }

    @Override
    public BinaryTupleOperator clone() {
        BinaryTupleOperator clone = (BinaryTupleOperator)super.clone();
        clone.setLeftArg(this.getLeftArg().clone());
        clone.setRightArg(this.getRightArg().clone());
        return clone;
    }
}

