/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.PushSynInfo;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.HeadersFrame;
import org.eclipse.jetty.spdy.frames.SynReplyFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StandardStream
implements IStream {
    private static final Logger LOG = Log.getLogger(Stream.class);
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final int id;
    private final byte priority;
    private final ISession session;
    private final IStream associatedStream;
    private final Promise<Stream> promise;
    private final AtomicInteger windowSize = new AtomicInteger();
    private final Set<Stream> pushedStreams = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile StreamFrameListener listener;
    private volatile OpenState openState = OpenState.SYN_SENT;
    private volatile CloseState closeState = CloseState.OPENED;
    private volatile boolean reset = false;

    public StandardStream(int id, byte priority, ISession session, IStream associatedStream, Promise<Stream> promise) {
        this.id = id;
        this.priority = priority;
        this.session = session;
        this.associatedStream = associatedStream;
        this.promise = promise;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public IStream getAssociatedStream() {
        return this.associatedStream;
    }

    @Override
    public Set<Stream> getPushedStreams() {
        return this.pushedStreams;
    }

    @Override
    public void associate(IStream stream) {
        this.pushedStreams.add(stream);
    }

    @Override
    public void disassociate(IStream stream) {
        this.pushedStreams.remove(stream);
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public int getWindowSize() {
        return this.windowSize.get();
    }

    @Override
    public void updateWindowSize(int delta) {
        int size = this.windowSize.addAndGet(delta);
        LOG.debug("Updated window size {} -> {} for {}", new Object[]{size - delta, size, this});
    }

    @Override
    public ISession getSession() {
        return this.session;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public void setStreamFrameListener(StreamFrameListener listener) {
        this.listener = listener;
    }

    @Override
    public StreamFrameListener getStreamFrameListener() {
        return this.listener;
    }

    @Override
    public void updateCloseState(boolean close, boolean local) {
        LOG.debug("{} close={} local={}", new Object[]{this, close, local});
        if (close) {
            switch (this.closeState) {
                case OPENED: {
                    this.closeState = local ? CloseState.LOCALLY_CLOSED : CloseState.REMOTELY_CLOSED;
                    break;
                }
                case LOCALLY_CLOSED: {
                    if (local) {
                        throw new IllegalStateException();
                    }
                    this.closeState = CloseState.CLOSED;
                    break;
                }
                case REMOTELY_CLOSED: {
                    if (local) {
                        this.closeState = CloseState.CLOSED;
                        break;
                    }
                    throw new IllegalStateException();
                }
                default: {
                    LOG.warn("Already CLOSED! {} local={}", new Object[]{this, local});
                }
            }
        }
    }

    @Override
    public void process(ControlFrame frame) {
        switch (frame.getType()) {
            case SYN_STREAM: {
                this.openState = OpenState.SYN_RECV;
                break;
            }
            case SYN_REPLY: {
                this.openState = OpenState.REPLY_RECV;
                SynReplyFrame synReply = (SynReplyFrame)frame;
                this.updateCloseState(synReply.isClose(), false);
                ReplyInfo replyInfo = new ReplyInfo(synReply.getHeaders(), synReply.isClose());
                this.notifyOnReply(replyInfo);
                break;
            }
            case HEADERS: {
                HeadersFrame headers = (HeadersFrame)frame;
                this.updateCloseState(headers.isClose(), false);
                HeadersInfo headersInfo = new HeadersInfo(headers.getHeaders(), headers.isClose(), headers.isResetCompression());
                this.notifyOnHeaders(headersInfo);
                break;
            }
            case RST_STREAM: {
                this.reset = true;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.session.flush();
    }

    @Override
    public void process(DataInfo dataInfo) {
        if (this.isRemotelyClosed()) {
            LOG.debug("Stream is remotely closed, ignoring {}", new Object[]{dataInfo});
            return;
        }
        if (!this.canReceive()) {
            LOG.debug("Protocol error receiving {}, resetting", new Object[]{dataInfo});
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR), (Callback)new Callback.Adapter());
            return;
        }
        this.updateCloseState(dataInfo.isClose(), false);
        this.notifyOnData(dataInfo);
        this.session.flush();
    }

    public void succeeded() {
        if (this.promise != null) {
            this.promise.succeeded((Object)this);
        }
    }

    public void failed(Throwable x) {
        if (this.promise != null) {
            this.promise.failed(x);
        }
    }

    private void notifyOnReply(ReplyInfo replyInfo) {
        StreamFrameListener listener = this.listener;
        try {
            if (listener != null) {
                LOG.debug("Invoking reply callback with {} on listener {}", new Object[]{replyInfo, listener});
                listener.onReply(this, replyInfo);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
            throw x;
        }
    }

    private void notifyOnHeaders(HeadersInfo headersInfo) {
        StreamFrameListener listener = this.listener;
        try {
            if (listener != null) {
                LOG.debug("Invoking headers callback with {} on listener {}", new Object[]{headersInfo, listener});
                listener.onHeaders(this, headersInfo);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
            throw x;
        }
    }

    private void notifyOnData(DataInfo dataInfo) {
        StreamFrameListener listener = this.listener;
        try {
            if (listener != null) {
                LOG.debug("Invoking data callback with {} on listener {}", new Object[]{dataInfo, listener});
                listener.onData(this, dataInfo);
                LOG.debug("Invoked data callback with {} on listener {}", new Object[]{dataInfo, listener});
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
            throw x;
        }
    }

    @Override
    public Stream push(PushInfo pushInfo) throws InterruptedException, ExecutionException, TimeoutException {
        FuturePromise result = new FuturePromise();
        this.push(pushInfo, (Promise<Stream>)result);
        if (pushInfo.getTimeout() > 0L) {
            return (Stream)result.get(pushInfo.getTimeout(), pushInfo.getUnit());
        }
        return (Stream)result.get();
    }

    @Override
    public void push(PushInfo pushInfo, Promise<Stream> promise) {
        if (this.isClosed() || this.isReset()) {
            promise.failed((Throwable)new StreamException(this.getId(), StreamStatus.STREAM_ALREADY_CLOSED, "Stream: " + this + " already closed or reset!"));
            return;
        }
        PushSynInfo pushSynInfo = new PushSynInfo(this.getId(), pushInfo);
        this.session.syn(pushSynInfo, null, promise);
    }

    @Override
    public void reply(ReplyInfo replyInfo) throws InterruptedException, ExecutionException, TimeoutException {
        FutureCallback result = new FutureCallback();
        this.reply(replyInfo, (Callback)result);
        if (replyInfo.getTimeout() > 0L) {
            result.get(replyInfo.getTimeout(), replyInfo.getUnit());
        } else {
            result.get();
        }
    }

    @Override
    public void reply(ReplyInfo replyInfo, Callback callback) {
        if (this.isUnidirectional()) {
            throw new IllegalStateException("Protocol violation: cannot send SYN_REPLY frames in unidirectional streams");
        }
        this.openState = OpenState.REPLY_SENT;
        this.updateCloseState(replyInfo.isClose(), true);
        SynReplyFrame frame = new SynReplyFrame(this.session.getVersion(), replyInfo.getFlags(), this.getId(), replyInfo.getHeaders());
        this.session.control(this, frame, replyInfo.getTimeout(), replyInfo.getUnit(), callback);
    }

    @Override
    public void data(DataInfo dataInfo) throws InterruptedException, ExecutionException, TimeoutException {
        FutureCallback result = new FutureCallback();
        this.data(dataInfo, (Callback)result);
        if (dataInfo.getTimeout() > 0L) {
            result.get(dataInfo.getTimeout(), dataInfo.getUnit());
        } else {
            result.get();
        }
    }

    @Override
    public void data(DataInfo dataInfo, Callback callback) {
        if (!this.canSend()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR), (Callback)new Callback.Adapter());
            throw new IllegalStateException("Protocol violation: cannot send a DATA frame before a SYN_REPLY frame");
        }
        if (this.isLocallyClosed()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR), (Callback)new Callback.Adapter());
            throw new IllegalStateException("Protocol violation: cannot send a DATA frame on a locally closed stream");
        }
        this.session.data(this, dataInfo, dataInfo.getTimeout(), dataInfo.getUnit(), callback);
    }

    @Override
    public void headers(HeadersInfo headersInfo) throws InterruptedException, ExecutionException, TimeoutException {
        FutureCallback result = new FutureCallback();
        this.headers(headersInfo, (Callback)result);
        if (headersInfo.getTimeout() > 0L) {
            result.get(headersInfo.getTimeout(), headersInfo.getUnit());
        } else {
            result.get();
        }
    }

    @Override
    public void headers(HeadersInfo headersInfo, Callback callback) {
        if (!this.canSend()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR), (Callback)new Callback.Adapter());
            throw new IllegalStateException("Protocol violation: cannot send a HEADERS frame before a SYN_REPLY frame");
        }
        if (this.isLocallyClosed()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR), (Callback)new Callback.Adapter());
            throw new IllegalStateException("Protocol violation: cannot send a HEADERS frame on a closed stream");
        }
        this.updateCloseState(headersInfo.isClose(), true);
        HeadersFrame frame = new HeadersFrame(this.session.getVersion(), headersInfo.getFlags(), this.getId(), headersInfo.getHeaders());
        this.session.control(this, frame, headersInfo.getTimeout(), headersInfo.getUnit(), callback);
    }

    @Override
    public boolean isUnidirectional() {
        return this.associatedStream != null;
    }

    @Override
    public boolean isReset() {
        return this.reset;
    }

    @Override
    public boolean isHalfClosed() {
        CloseState closeState = this.closeState;
        return closeState == CloseState.LOCALLY_CLOSED || closeState == CloseState.REMOTELY_CLOSED || closeState == CloseState.CLOSED;
    }

    @Override
    public boolean isClosed() {
        return this.closeState == CloseState.CLOSED;
    }

    private boolean isLocallyClosed() {
        CloseState closeState = this.closeState;
        return closeState == CloseState.LOCALLY_CLOSED || closeState == CloseState.CLOSED;
    }

    private boolean isRemotelyClosed() {
        CloseState closeState = this.closeState;
        return closeState == CloseState.REMOTELY_CLOSED || closeState == CloseState.CLOSED;
    }

    public String toString() {
        return String.format("stream=%d v%d windowSize=%d reset=%s prio=%d %s %s", new Object[]{this.getId(), this.session.getVersion(), this.getWindowSize(), this.isReset(), this.priority, this.openState, this.closeState});
    }

    private boolean canSend() {
        OpenState openState = this.openState;
        return openState == OpenState.SYN_SENT || openState == OpenState.REPLY_RECV || openState == OpenState.REPLY_SENT;
    }

    private boolean canReceive() {
        OpenState openState = this.openState;
        return openState == OpenState.SYN_RECV || openState == OpenState.REPLY_RECV || openState == OpenState.REPLY_SENT;
    }

    private static enum CloseState {
        OPENED,
        LOCALLY_CLOSED,
        REMOTELY_CLOSED,
        CLOSED;

    }

    private static enum OpenState {
        SYN_SENT,
        SYN_RECV,
        REPLY_SENT,
        REPLY_RECV;

    }
}

