/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import org.fest.reflect.core.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Tests {
    private static final String JUNIT4_TEST_CASE_FACADE_TYPE = "junit.framework.JUnit4TestCaseFacade";
    private static Method testCaseName = Tests.nameMethodIn(TestCase.class);

    Tests() {
    }

    static String testMethodNameFrom(Test test) {
        if (test == null) {
            return "unknown";
        }
        if (Tests.isJUnit4TestCaseFacade(test)) {
            return Tests.trimClassNameFromMethodName(test.toString());
        }
        if (test instanceof TestCase && testCaseName != null) {
            return Tests.invokeNameMethod(testCaseName, test);
        }
        return Tests.invokeNameMethod(Tests.nameMethodIn(test.getClass()), test);
    }

    private static boolean isJUnit4TestCaseFacade(Test test) {
        return Tests.isJunit4TestCaseFacade(test);
    }

    private static String trimClassNameFromMethodName(String name) {
        if (!name.endsWith(")")) {
            return name;
        }
        return name.substring(0, name.lastIndexOf(40));
    }

    private static Method nameMethodIn(Class<?> type) {
        return Tests.methodInType(type, "getName", "name");
    }

    private static Method methodInType(Class<?> type, String name, String alternativeName) {
        Method m = Tests.methodInType(type, name);
        if (m != null) {
            return m;
        }
        return Tests.methodInType(type, alternativeName);
    }

    private static Method methodInType(Class<?> type, String name) {
        try {
            return type.getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String invokeNameMethod(Method m, Object target) {
        if (m == null || m.getReturnType() != String.class) {
            return "unknown";
        }
        try {
            return (String)m.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    static String testClassNameFrom(Test test) {
        String className = Tests.classNameOf(test);
        if (className.endsWith("VmExitErrorTest")) {
            return Tests.classNameFromVmExitErrorTest(test);
        }
        if (Tests.isJunit4TestCaseFacade(test)) {
            return Tests.testClassNameFromJUnit4TestCaseFacade(test);
        }
        return className;
    }

    private static String classNameFromVmExitErrorTest(Test test) {
        try {
            return (String)Reflection.method((String)"getClassName").withReturnType(String.class).in((Object)test).invoke(new Object[0]);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private static boolean isJunit4TestCaseFacade(Test test) {
        return Tests.classNameOf(test).equals(JUNIT4_TEST_CASE_FACADE_TYPE);
    }

    private static String testClassNameFromJUnit4TestCaseFacade(Test test) {
        String name = test.toString();
        int i = name.lastIndexOf(40);
        if (i == -1) {
            return Tests.classNameOf(test);
        }
        if (!name.endsWith(")")) {
            return Tests.classNameOf(test);
        }
        return name.substring(i + 1, name.length() - 1);
    }

    private static String classNameOf(Test test) {
        return test.getClass().getName();
    }
}

