/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Test;
import org.fest.swing.junit.xml.XmlNode;

class TestCollection {
    final Map<Test, XmlNode> testXml = new ConcurrentHashMap<Test, XmlNode>();
    final List<Test> failed = new CopyOnWriteArrayList<Test>();
    final Map<Test, Long> started = new ConcurrentHashMap<Test, Long>();

    TestCollection() {
    }

    void started(Test test) {
        this.started.put(test, System.currentTimeMillis());
    }

    boolean wasStarted(Test test) {
        return this.started.containsKey(test);
    }

    long startTimeOf(Test test) {
        return this.started.get(test);
    }

    void addXmlNode(Test test, XmlNode n) {
        this.testXml.put(test, n);
    }

    XmlNode xmlNodeFor(Test test) {
        return this.testXml.get(test);
    }

    boolean wasFailed(Test test) {
        return this.failed.contains(test);
    }

    void failed(Test test) {
        this.failed.add(test);
    }
}

