/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.fluent.impl;

import org.drools.core.command.EndConversationCommand;
import org.drools.core.command.JoinConversationCommand;
import org.drools.core.command.LeaveConversationCommand;
import org.drools.core.command.OutCommand;
import org.drools.core.command.StartConversationCommand;
import org.drools.core.fluent.impl.BatchImpl;
import org.drools.core.fluent.impl.ExecutableImpl;
import org.drools.core.fluent.impl.GetCommand;
import org.drools.core.fluent.impl.GetContextCommand;
import org.drools.core.fluent.impl.NewContextCommand;
import org.drools.core.fluent.impl.SetCommand;
import org.drools.core.fluent.impl.SetVarAsRegistryEntry;
import org.kie.api.command.Command;
import org.kie.api.runtime.builder.ContextFluent;
import org.kie.api.runtime.builder.Scope;

public class BaseBatchFluent<T, E>
implements ContextFluent<T, E> {
    protected ExecutableImpl fluentCtx;

    public BaseBatchFluent(ExecutableImpl fluentCtx) {
        this.fluentCtx = fluentCtx;
    }

    public ExecutableImpl getFluentContext() {
        return this.fluentCtx;
    }

    public T addCommand(Command command) {
        this.fluentCtx.addCommand(command);
        return (T)this;
    }

    public T after(long distance) {
        this.fluentCtx.addBatch(new BatchImpl(distance));
        return (T)this;
    }

    public T relativeAfter(long duration) {
        return (T)this;
    }

    public T out() {
        this.fluentCtx.addCommand((Command)new OutCommand());
        return (T)this;
    }

    public T out(String name) {
        this.fluentCtx.addCommand((Command)new OutCommand(name));
        return (T)this;
    }

    public T set(String name, Scope scope) {
        this.fluentCtx.addCommand((Command)new SetCommand(name, scope));
        return (T)this;
    }

    public T set(String name) {
        this.fluentCtx.addCommand((Command)new SetCommand(name));
        return (T)this;
    }

    public T get(String name) {
        this.fluentCtx.addCommand((Command)new GetCommand(name));
        return (T)this;
    }

    public T get(String name, Scope scope) {
        this.fluentCtx.addCommand((Command)new GetCommand(name, scope));
        return (T)this;
    }

    public <K> K get(String name, Class<K> cls) {
        String fluentTarget = this.getFluentContext().getFactory().getFluentTarget(cls.getName());
        this.addCommand((Command)new SetVarAsRegistryEntry(fluentTarget, name));
        K object = null;
        try {
            Class imlpCls = this.getFluentContext().getFactory().getImplClass(cls.getName());
            object = (K)imlpCls.getDeclaredConstructor(ExecutableImpl.class).newInstance(this.getFluentContext());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate fluent " + cls.getName(), e);
        }
        return object;
    }

    public T newApplicationContext(String name) {
        this.addCommand((Command)new NewContextCommand(name));
        return (T)this;
    }

    public T getApplicationContext(String name) {
        this.addCommand((Command)new GetContextCommand(name));
        return (T)this;
    }

    public T startConversation() {
        this.fluentCtx.addCommand((Command)new StartConversationCommand());
        return (T)this;
    }

    public T joinConversation(String uuid) {
        this.fluentCtx.addCommand((Command)new JoinConversationCommand(uuid));
        return (T)this;
    }

    public T leaveConversation() {
        this.fluentCtx.addCommand((Command)new LeaveConversationCommand());
        return (T)this;
    }

    public T endConversation(String uuid) {
        this.fluentCtx.addCommand((Command)new EndConversationCommand(uuid));
        return (T)this;
    }

    public E end() {
        return (E)this.fluentCtx.getExecutableBuilder();
    }
}

