/*
 *
 * The DbUnit Database Testing Framework
 * Copyright (C)2002-2008, DbUnit.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package org.dbunit.ext.oracle;

import java.sql.SQLException;
import java.sql.Connection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.jpub.runtime.MutableStruct;

/**
 * This class was generated by oracle jpub.
 *
 * @see OracleSdoGeometryDataType
 * @author clucas@e-miles.com
 * @author Last changed by: $Author$
 * @version $Revision$ $Date$
 * @since ?
 */
public class OracleSdoGeometry implements ORAData, ORADataFactory
{
  public static final String _SQL_NAME = "MDSYS.SDO_GEOMETRY";
  public static final int _SQL_TYPECODE = OracleTypes.STRUCT;

  protected MutableStruct _struct;

  protected static int[] _sqlType =  { 2,2,2002,2003,2003 };
  protected static ORADataFactory[] _factory = new ORADataFactory[5];
  static
  {
    _factory[2] = OracleSdoPointType.getORADataFactory();
    _factory[3] = OracleSdoElemInfoArray.getORADataFactory();
    _factory[4] = OracleSdoOrdinateArray.getORADataFactory();
  }
  protected static final OracleSdoGeometry _OracleSdoGeometryFactory = new OracleSdoGeometry();

  public static ORADataFactory getORADataFactory()
  { return _OracleSdoGeometryFactory; }
  /* constructors */
  protected void _init_struct(boolean init)
  { if (init) _struct = new MutableStruct(new Object[5], _sqlType, _factory); }
  public OracleSdoGeometry()
  { _init_struct(true); }
  public OracleSdoGeometry(java.math.BigDecimal sdoGtype, java.math.BigDecimal sdoSrid, OracleSdoPointType sdoPoint, OracleSdoElemInfoArray sdoElemInfo, OracleSdoOrdinateArray sdoOrdinates) throws SQLException
  { _init_struct(true);
    setSdoGtype(sdoGtype);
    setSdoSrid(sdoSrid);
    setSdoPoint(sdoPoint);
    setSdoElemInfo(sdoElemInfo);
    setSdoOrdinates(sdoOrdinates);
  }

  /* ORAData interface */
  public Datum toDatum(Connection c) throws SQLException
  {
    return _struct.toDatum(c, _SQL_NAME);
  }


  /* ORADataFactory interface */
  public ORAData create(Datum d, int sqlType) throws SQLException
  { return create(null, d, sqlType); }
  protected ORAData create(OracleSdoGeometry o, Datum d, int sqlType) throws SQLException
  {
    if (d == null) return null; 
    if (o == null) o = new OracleSdoGeometry();
    o._struct = new MutableStruct((STRUCT) d, _sqlType, _factory);
    return o;
  }
  /* accessor methods */
  public java.math.BigDecimal getSdoGtype() throws SQLException
  { return (java.math.BigDecimal) _struct.getAttribute(0); }

  public void setSdoGtype(java.math.BigDecimal sdoGtype) throws SQLException
  { _struct.setAttribute(0, sdoGtype); }


  public java.math.BigDecimal getSdoSrid() throws SQLException
  { return (java.math.BigDecimal) _struct.getAttribute(1); }

  public void setSdoSrid(java.math.BigDecimal sdoSrid) throws SQLException
  { _struct.setAttribute(1, sdoSrid); }


  public OracleSdoPointType getSdoPoint() throws SQLException
  { return (OracleSdoPointType) _struct.getAttribute(2); }

  public void setSdoPoint(OracleSdoPointType sdoPoint) throws SQLException
  { _struct.setAttribute(2, sdoPoint); }


  public OracleSdoElemInfoArray getSdoElemInfo() throws SQLException
  { return (OracleSdoElemInfoArray) _struct.getAttribute(3); }

  public void setSdoElemInfo(OracleSdoElemInfoArray sdoElemInfo) throws SQLException
  { _struct.setAttribute(3, sdoElemInfo); }


  public OracleSdoOrdinateArray getSdoOrdinates() throws SQLException
  { return (OracleSdoOrdinateArray) _struct.getAttribute(4); }

  public void setSdoOrdinates(OracleSdoOrdinateArray sdoOrdinates) throws SQLException
  { _struct.setAttribute(4, sdoOrdinates); }

  public String toString()
  { try {
     return "MDSYS.SDO_GEOMETRY" + "(" +
       getSdoGtype() + "," +
       getSdoSrid() + "," +
       getSdoPoint() + "," +
       getSdoElemInfo() + "," +
       getSdoOrdinates() +
     ")";
    } catch (Exception e) { return e.toString(); }
  }

    public boolean equals(Object obj)
    {
        if (this == obj)
        {
            return true;
        }

        if (obj == null || ! obj.getClass().equals(this.getClass()))
        {
            return false;
        }

        OracleSdoGeometry otherSdoGeom = (OracleSdoGeometry) obj;

        try
        {
            return
                OracleSdoHelper.objectsEqual(getSdoGtype(), otherSdoGeom.getSdoGtype()) &&
                OracleSdoHelper.objectsEqual(getSdoSrid(), otherSdoGeom.getSdoSrid()) &&
                OracleSdoHelper.objectsEqual(getSdoPoint(), otherSdoGeom.getSdoPoint()) &&
                OracleSdoHelper.objectsEqual(getSdoElemInfo(), otherSdoGeom.getSdoElemInfo()) &&
                OracleSdoHelper.objectsEqual(getSdoOrdinates(), otherSdoGeom.getSdoOrdinates());
        }
        catch (SQLException ex)
        {
            return false;
        }
    }

    public int hashCode()
    {
        try
        {
            int hash = 7;
            Object o;
            o = getSdoGtype();
            hash = 31 * hash + (null == o ? 0 : o.hashCode());
            o = getSdoSrid();
            hash = 31 * hash + (null == o ? 0 : o.hashCode());
            o = getSdoPoint();
            hash = 31 * hash + (null == o ? 0 : o.hashCode());
            o = getSdoElemInfo();
            hash = 31 * hash + (null == o ? 0 : o.hashCode());
            o = getSdoOrdinates();
            hash = 31 * hash + (null == o ? 0 : o.hashCode());
            return hash;
        }
        catch (SQLException ex)
        {
            return 0;
        }
    }
}
