/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.issue.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.wsclient.internal.EncodingUtils;
import org.sonar.wsclient.internal.HttpRequestFactory;
import org.sonar.wsclient.issue.ActionPlan;
import org.sonar.wsclient.issue.ActionPlanClient;
import org.sonar.wsclient.issue.NewActionPlan;
import org.sonar.wsclient.issue.UpdateActionPlan;
import org.sonar.wsclient.issue.internal.DefaultActionPlan;
import org.sonar.wsclient.jsonsimple.JSONValue;

public class DefaultActionPlanClient
implements ActionPlanClient {
    private final HttpRequestFactory requestFactory;

    public DefaultActionPlanClient(HttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Override
    public List<ActionPlan> find(String projectKey) {
        String json = this.requestFactory.get("/api/action_plans/search", EncodingUtils.toMap("project", projectKey));
        ArrayList<ActionPlan> result = new ArrayList<ActionPlan>();
        Map jsonRoot = (Map)JSONValue.parse(json);
        List jsonActionPlans = (List)jsonRoot.get("actionPlans");
        if (jsonActionPlans != null) {
            for (Map jsonActionPlan : jsonActionPlans) {
                result.add(new DefaultActionPlan(jsonActionPlan));
            }
        }
        return result;
    }

    @Override
    public ActionPlan create(NewActionPlan newActionPlan) {
        String json = this.requestFactory.post("/api/action_plans/create", newActionPlan.urlParams());
        return this.createActionPlanResult(json);
    }

    @Override
    public ActionPlan update(UpdateActionPlan updateActionPlan) {
        String json = this.requestFactory.post("/api/action_plans/update", updateActionPlan.urlParams());
        return this.createActionPlanResult(json);
    }

    @Override
    public void delete(String actionPlanKey) {
        this.executeSimpleAction(actionPlanKey, "delete");
    }

    @Override
    public ActionPlan open(String actionPlanKey) {
        String json = this.executeSimpleAction(actionPlanKey, "open");
        return this.createActionPlanResult(json);
    }

    @Override
    public ActionPlan close(String actionPlanKey) {
        String json = this.executeSimpleAction(actionPlanKey, "close");
        return this.createActionPlanResult(json);
    }

    private String executeSimpleAction(String actionPlanKey, String action) {
        return this.requestFactory.post("/api/action_plans/" + action, EncodingUtils.toMap("key", actionPlanKey));
    }

    private ActionPlan createActionPlanResult(String json) {
        Map jsonRoot = (Map)JSONValue.parse(json);
        return new DefaultActionPlan((Map)jsonRoot.get("actionPlan"));
    }
}

