/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.StoreElementAttribute;
import com.canoo.webtest.steps.verify.AbstractVerifyTextStep;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VerifyElementText
extends AbstractVerifyTextStep {
    private static final Logger LOG = Logger.getLogger(VerifyElementText.class);
    private String fType;
    private String fName;
    private String fHtmlId;

    public void doExecute() {
        HtmlElement elt = StringUtils.isEmpty((String)this.getHtmlId()) ? this.findElementByTypeAndOptionalName() : StoreElementAttribute.findElement(this.getContext().getCurrentResponse(), this.getHtmlId(), null, LOG, this);
        if (!this.verifyText(this.readText(elt))) {
            throw new StepFailedException(this.getFailedMessage(), this.getText(), this.readText(elt), this);
        }
    }

    private HtmlElement findElementByTypeAndOptionalName() {
        HtmlElement elt;
        List li = ((HtmlPage)this.getContext().getCurrentResponse()).getDocumentElement().getHtmlElementsByTagName(this.getType());
        LOG.debug((Object)(li.size() + " elts found of type \"" + this.getType() + "\""));
        if (li.isEmpty()) {
            throw new StepFailedException("No element found of type \"" + this.getType() + "\"", this);
        }
        if (li.size() > 1 && this.getName() == null) {
            throw new StepFailedException("More than 1 element with type \"" + this.getType() + "\" found! No name is specified.", this);
        }
        if (this.getName() != null) {
            List namedElements = VerifyElementText.findNodesWithAttribute(li, "name", this.getName());
            if (namedElements.isEmpty()) {
                throw new StepFailedException("No element of type \"" + this.getType() + "\" and name \"" + this.getName() + "\" found!", this);
            }
            if (namedElements.size() > 1) {
                throw new StepFailedException("More than 1 element of type \"" + this.getType() + "\" with name \"" + this.getName() + "\" found!", this);
            }
            elt = (HtmlElement)namedElements.get(0);
        } else {
            elt = (HtmlElement)li.get(0);
        }
        return elt;
    }

    protected String readText(HtmlElement elt) {
        LOG.debug((Object)("Reading text for " + elt));
        return elt.asText();
    }

    protected static List findNodesWithAttribute(List li, String attributeName, String attributeValue) {
        LOG.debug((Object)("Looking in list for elements with attribute \"" + attributeName + "\"'s value: \"" + attributeValue + "\""));
        ArrayList<HtmlElement> result = new ArrayList<HtmlElement>();
        for (HtmlElement elt : li) {
            String strValue = elt.getAttribute(attributeName);
            if (attributeValue.equals(strValue)) {
                result.add(elt);
                continue;
            }
            LOG.debug((Object)("Value: \"" + strValue + "\" => not ok for " + elt));
        }
        LOG.debug((Object)(result.size() + " element(s) found"));
        return result;
    }

    protected String getFailedMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("Wrong contents found in HTML element (type=\"");
        sb.append(this.getType());
        sb.append("\", name=\"");
        sb.append(this.getName());
        sb.append("\", htmlId=\"");
        sb.append(this.getHtmlId());
        sb.append("\")!");
        return sb.toString();
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String newName) {
        this.fName = newName;
    }

    public String getType() {
        return this.fType;
    }

    public void setType(String newType) {
        this.fType = newType;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void setHtmlId(String htmlId) {
        this.fHtmlId = htmlId;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(StringUtils.isEmpty((String)this.getType()) && StringUtils.isEmpty((String)this.getHtmlId()), "One of 'htmlId' or 'type' must be set.");
    }
}

