/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.store;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.canoo.webtest.util.ConversionUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StoreRegExMatch
extends BaseStoreStep {
    private String fText;
    private String fGroup;

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
    }

    public void setProperty(String property) {
        super.setProperty(property);
    }

    public void setGroup(String group) {
        this.fGroup = group;
    }

    public void doExecute() throws IOException {
        this.nullResponseCheck();
        String text = this.getContext().getCurrentResponse().getWebResponse().getContentAsString();
        Matcher matcher = Pattern.compile(this.getText(), 32).matcher(text);
        if (!matcher.find()) {
            throw new StepFailedException("No match for regular expression <" + this.getText() + ">", this);
        }
        int numberOfGroups = matcher.groupCount();
        int groupNumber = ConversionUtil.convertToInt(this.fGroup, 0);
        if (groupNumber > numberOfGroups) {
            throw new StepFailedException("Group not found: " + this.fGroup + " (#groups: " + numberOfGroups + ")", this);
        }
        this.storeProperty(matcher.group(groupNumber));
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.optionalIntegerParamCheck(this.fGroup, "group", true);
        this.emptyParamCheck(this.getText(), "Regular expression (text attribute)");
        this.emptyParamCheck(this.getProperty(), "property");
    }
}

