/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.store;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.canoo.webtest.util.MapUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StoreCookie
extends BaseStoreStep {
    private static final Logger LOG = Logger.getLogger(StoreCookie.class);
    private String fCookieName;
    private String fCookieValue;

    public void setName(String name) {
        this.fCookieName = name;
    }

    public String getName() {
        return this.fCookieName;
    }

    public void doExecute() {
        Cookie[] cookies = StoreCookie.getCookies(this.getContext());
        LOG.debug((Object)("Found " + cookies.length + " cookie(s)"));
        if (cookies.length == 0) {
            throw new StepFailedException("No cookies set!", this);
        }
        Cookie cookie = this.findCookie(cookies);
        if (cookie == null) {
            throw new StepFailedException("Cookie \"" + this.fCookieName + "\" not set!", this);
        }
        this.storeProperty(cookie.getValue(), this.getName());
        this.fCookieValue = cookie.getValue();
    }

    protected void addComputedParameters(Map map) {
        MapUtil.putIfNotNull(map, "-> cookie value", this.fCookieValue);
    }

    Cookie findCookie(Cookie[] cookies) {
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(this.fCookieName)) continue;
            return cookie;
        }
        return null;
    }

    public static Cookie[] getCookies(Context context) {
        URL url = context.getCurrentResponse().getUrl();
        WebClient webClient = context.getWebClient();
        Set cookies = webClient.getCookieManager().getCookies(url);
        return cookies.toArray(new Cookie[0]);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.fCookieName, "name");
        this.nullResponseCheck();
    }
}

