/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyPdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;

public class PdfVerifyTextStep
extends AbstractVerifyPdfStep {
    public static final int FIRST_PAGE = 1;
    public static final int LAST_PAGE = -1;
    private int fStartPage = 1;
    private int fEndPage = -1;
    private boolean fRegex;
    private String fText;

    public void setStartPage(int startPage) {
        this.fStartPage = startPage;
    }

    public int getStartPage() {
        return this.fStartPage;
    }

    public void setEndPage(int endPage) {
        this.fEndPage = endPage;
    }

    public int getEndPage() {
        return this.fEndPage;
    }

    public void setRegex(boolean regex) {
        this.fRegex = regex;
    }

    public boolean getRegex() {
        return this.fRegex;
    }

    public void setText(String text) {
        this.fText = text;
    }

    public String getText() {
        return this.fText;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getText(), "text");
    }

    protected void verifyPdf(PDFPage pdfPage) {
        boolean ok;
        int lastPage = this.getEndPage() == -1 ? pdfPage.getNumberOfPages() : this.getEndPage();
        String text = pdfPage.getText(this.getStartPage(), lastPage);
        if (this.getRegex()) {
            ok = PdfVerifyTextStep.getVerifier(true).verifyStrings(this.getText(), text);
        } else {
            boolean bl = ok = text.indexOf(this.getText()) > -1;
        }
        if (!ok) {
            throw new StepFailedException("Text not found in pdf text \"" + text + "\"");
        }
    }
}

