/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.plugins.emailtest.AbstractEmailFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmailMessageStructureFilter
extends AbstractEmailFilter {
    private static final Logger LOG = Logger.getLogger(EmailMessageStructureFilter.class);
    private static final String LS = System.getProperty("line.separator");
    private String fHeaders;
    private String[] fTokenizedHeaders;

    public String getHeaders() {
        return this.fHeaders;
    }

    public void setHeaders(String headers) {
        this.fHeaders = headers;
    }

    protected void filterContent(Message message) throws MessagingException {
        if (!StringUtils.isEmpty((String)this.getHeaders())) {
            this.prepareHeaders();
        }
        try {
            Object content = message.getContent();
            if (content instanceof Multipart) {
                this.filterMultiPartMessage(content, message);
                return;
            }
            this.filterSimpleMessage((String)content, message);
        }
        catch (IOException e) {
            LOG.error((Object)"Error processing email message: ", (Throwable)e);
            throw new MessagingException("Error processing email message: " + e.getMessage());
        }
    }

    private void prepareHeaders() {
        StringTokenizer tokens = new StringTokenizer(this.getHeaders(), " ,");
        this.fTokenizedHeaders = new String[tokens.countTokens()];
        for (int i = 0; i < this.fTokenizedHeaders.length; ++i) {
            this.fTokenizedHeaders[i] = tokens.nextToken();
        }
    }

    private void filterMultiPartMessage(Object content, Message message) throws MessagingException {
        Multipart parts = (Multipart)content;
        StringBuffer buf = new StringBuffer();
        buf.append("<message type=\"MIME\" contentType=\"");
        buf.append(EmailMessageStructureFilter.extractBaseContentType(message.getContentType())).append("\">").append(LS);
        this.processHeaders(buf, message);
        int count = parts.getCount();
        for (int i = 0; i < count; ++i) {
            buf.append(EmailMessageStructureFilter.processMessagePart((Part)parts.getBodyPart(i)));
        }
        buf.append("</message>");
        this.defineAsCurrentResponse(buf.toString().getBytes(), "text/xml");
    }

    private void processHeaders(StringBuffer buf, Message message) throws MessagingException {
        if (this.fTokenizedHeaders != null) {
            Enumeration allHeaders = message.getAllHeaders();
            while (allHeaders.hasMoreElements()) {
                Header header = (Header)allHeaders.nextElement();
                if (!this.headerIsRequired(header)) continue;
                buf.append(EmailMessageStructureFilter.processHeader(header));
            }
        }
    }

    private boolean headerIsRequired(Header header) {
        for (int i = 0; i < this.fTokenizedHeaders.length; ++i) {
            if (!this.fTokenizedHeaders[i].equalsIgnoreCase(header.getName())) continue;
            return true;
        }
        return false;
    }

    private static String processHeader(Header h) {
        return "    <header name=\"" + h.getName() + "\" value=\"" + h.getValue() + "\"/>" + LS;
    }

    private void filterSimpleMessage(String content, Message message) throws MessagingException {
        StringBuffer buf = new StringBuffer("<message type=\"Simple\" contentType=\"");
        buf.append(EmailMessageStructureFilter.extractBaseContentType(message.getContentType())).append("\">").append(LS);
        this.processHeaders(buf, message);
        EmailMessageStructureFilter.appendUuencodedAttachments(buf, content);
        buf.append("</message>");
        this.defineAsCurrentResponse(buf.toString(), "text/xml");
    }

    private static void appendUuencodedAttachments(StringBuffer buf, String content) {
        String lineStr = "(^.*$)";
        String startUuencodeStr = "begin \\d\\d\\d .*";
        Pattern linePattern = Pattern.compile("(^.*$)", 8);
        Matcher matcher = linePattern.matcher(content);
        while (matcher.find()) {
            String line = matcher.group(0);
            if (!line.matches("begin \\d\\d\\d .*")) continue;
            int lastSpace = line.lastIndexOf(" ");
            String filename = line.substring(lastSpace + 1);
            buf.append("    <part type=\"uuencoded\" filename=\"");
            buf.append(filename).append("\"/>").append(LS);
        }
    }

    private static String processMessagePart(Part part) throws MessagingException {
        String disp = part.getDisposition();
        String contentType = part.getContentType();
        if ("attachment".equals(disp)) {
            return "    <part type=\"attachment\" filename=\"" + part.getFileName() + "\" contentType=\"" + EmailMessageStructureFilter.extractBaseContentType(contentType) + "\"/>" + LS;
        }
        return "    <part type=\"inline\" contentType=\"" + EmailMessageStructureFilter.extractBaseContentType(contentType) + "\"/>" + LS;
    }

    private static String extractBaseContentType(String orig) {
        int colonStart = orig.indexOf(";");
        if (colonStart == -1) {
            return orig;
        }
        return orig.substring(0, colonStart);
    }
}

