/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.ant;

import com.canoo.webtest.ant.IPropertyExpansionListener;
import com.canoo.webtest.ant.WebtestTask;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.extension.ScriptStep;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;

public class WebtestPropertyHelper
extends PropertyHelper {
    private static final Logger LOG = Logger.getLogger(WebtestPropertyHelper.class);
    private final PropertyHelper fWrappedHelper;
    private Project fProject;

    public WebtestPropertyHelper(Project project) {
        this.fWrappedHelper = PropertyHelper.getPropertyHelper((Project)project);
        this.setProject(project);
    }

    protected static void definePropertyHelper(Project project, PropertyHelper propertyHelper) {
        project.getReferences().remove("ant.PropertyHelper");
        project.addReference("ant.PropertyHelper", (Object)propertyHelper);
    }

    public static void configureWebtestPropertyHelper(Project project) {
        WebtestPropertyHelper propertyHelper = new WebtestPropertyHelper(project);
        propertyHelper.setProject(project);
        WebtestPropertyHelper.definePropertyHelper(project, propertyHelper);
    }

    public void copyInheritedProperties(Project other) {
        this.fWrappedHelper.copyInheritedProperties(other);
    }

    public void copyUserProperties(Project other) {
        this.fWrappedHelper.copyUserProperties(other);
    }

    public PropertyHelper getNext() {
        return this.fWrappedHelper.getNext();
    }

    public Hashtable getProperties() {
        return this.fWrappedHelper.getProperties();
    }

    public Object getProperty(String ns, String name) {
        return this.fWrappedHelper.getProperty(ns, name);
    }

    public Object getPropertyHook(String ns, String name, boolean user) {
        return this.fWrappedHelper.getPropertyHook(ns, name, user);
    }

    public Hashtable getUserProperties() {
        return this.fWrappedHelper.getUserProperties();
    }

    public Object getUserProperty(String ns, String name) {
        return this.fWrappedHelper.getUserProperty(ns, name);
    }

    public void parsePropertyString(String value, Vector fragments, Vector propertyRefs) throws BuildException {
        this.fWrappedHelper.parsePropertyString(value, fragments, propertyRefs);
    }

    public void setInheritedProperty(String ns, String name, Object value) {
        this.fWrappedHelper.setInheritedProperty(ns, name, value);
    }

    public void setNewProperty(String ns, String name, Object value) {
        this.fWrappedHelper.setNewProperty(ns, name, value);
    }

    public void setNext(PropertyHelper next) {
        this.fWrappedHelper.setNext(next);
    }

    public void setProject(Project p) {
        this.fProject = p;
        super.setProject(p);
        this.fWrappedHelper.setProject(p);
    }

    public boolean setProperty(String ns, String name, Object value, boolean verbose) {
        return this.fWrappedHelper.setProperty(ns, name, value, verbose);
    }

    public boolean setPropertyHook(String ns, String name, Object value, boolean inherited, boolean user, boolean isNew) {
        return this.fWrappedHelper.setPropertyHook(ns, name, value, inherited, user, isNew);
    }

    public void setUserProperty(String ns, String name, Object value) {
        this.fWrappedHelper.setUserProperty(ns, name, value);
    }

    public String replaceProperties(String ns, String value, Hashtable keys) throws BuildException {
        if (value == null) {
            return null;
        }
        String str = this.replacePropertiesInternal(ns, value, keys);
        if (!str.equals(value)) {
            LOG.debug((Object)("Notifying listeners of properties expansion: " + value + " -> " + str));
            for (BuildListener listener : this.fProject.getBuildListeners()) {
                if (!(listener instanceof IPropertyExpansionListener)) continue;
                ((IPropertyExpansionListener)listener).propertiesExpanded(value, str);
            }
        }
        return str;
    }

    private String replacePropertiesInternal(String ns, String value, Hashtable keys) {
        int length = value.length();
        if (length < 4) {
            return value;
        }
        int posStart = value.indexOf(123, 1);
        while (posStart != -1) {
            int posClosing;
            char prec = value.charAt(posStart - 1);
            if ((prec == '$' || prec == '#') && (posClosing = this.getMatchingClosing(value, posStart)) != -1) {
                String propValue;
                String propertyContent = value.substring(posStart + 1, posClosing);
                String expandedContent = this.replacePropertiesInternal(ns, propertyContent, keys);
                String replacement = prec == '#' ? ((propValue = this.getDynamicPropertyValue(expandedContent)) == null ? "#{" + expandedContent + "}" : propValue) : super.replaceProperties(ns, "${" + expandedContent + "}", keys);
                return value.substring(0, posStart - 1) + replacement + this.replacePropertiesInternal(ns, value.substring(posClosing + 1), keys);
            }
            posStart = value.indexOf(123, posStart + 1);
        }
        return value;
    }

    private int getMatchingClosing(String value, int posStart) {
        int length = value.length();
        int opened = 0;
        for (int i = posStart + 1; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '}') {
                if (opened == 0) {
                    return i;
                }
                --opened;
                continue;
            }
            if (c != '{') continue;
            ++opened;
        }
        return -1;
    }

    private String getDynamicPropertyValue(String propName) {
        if (propName.startsWith("script:")) {
            Context context = WebtestTask.getThreadContext();
            if (context == null || context.getRunner() == null) {
                return null;
            }
            String expr = StringUtils.substringAfter((String)propName, (String)"script:");
            return ScriptStep.evalScriptExpression(context, expr, null);
        }
        return (String)this.getDynamicProperties().get(propName);
    }

    Map getDynamicProperties() {
        return WebtestTask.getThreadContext().getWebtest().getDynamicProperties();
    }

    public static String expandDynamicProperties(Map properties, String text) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        String result = text;
        for (Map.Entry currentProperty : properties.entrySet()) {
            String propName = "#{" + currentProperty.getKey() + "}";
            int index = result.indexOf(propName);
            while (index >= 0) {
                String propValue = String.valueOf(currentProperty.getValue());
                StringBuffer newResult = new StringBuffer(result.substring(0, index));
                newResult.append(propValue);
                newResult.append(result.substring(index + propName.length(), result.length()));
                result = newResult.toString();
                index = result.indexOf(propName, index + propValue.length());
            }
        }
        return result;
    }
}

