/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.util.List;
import java.util.Locale;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.mojo.wagon.shared.WagonFactory;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=WagonFactory.class, hint="default")
public class DefaultWagonFactory
implements WagonFactory,
Contextualizable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private SettingsDecrypter settingsDecrypter;
    @Requirement(hint="basic")
    private ComponentConfigurator componentConfigurator;
    @Requirement(hint="map-oriented")
    private ComponentConfigurator mapComponentConfigurator;
    private PlexusContainer container;

    @Override
    public Wagon create(String url, String serverId, Settings settings) throws WagonException {
        Wagon wagon;
        Repository repository = new Repository(serverId, url == null ? "" : url);
        repository.setPermissions(DefaultWagonFactory.getPermissions(serverId, settings));
        if (url == null) {
            wagon = this.createAndConfigureWagon(serverId, settings, repository);
        } else {
            wagon = this.getWagon(repository.getProtocol());
            this.configureWagon(wagon, serverId, settings);
        }
        if (this.logger.isDebugEnabled()) {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
        }
        AuthenticationInfo authInfo = this.getAuthenticationInfo(serverId, settings);
        ProxyInfo proxyInfo = DefaultWagonFactory.getProxyInfo(settings);
        wagon.connect(repository, authInfo, proxyInfo);
        return wagon;
    }

    private Wagon createAndConfigureWagon(String repositoryId, Settings settings, Repository repository) throws WagonException {
        Wagon wagon = null;
        for (Server server : settings.getServers()) {
            String url;
            String id = server.getId();
            if (id == null || !id.equals(repositoryId)) continue;
            Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
            String string = url = configuration == null ? null : configuration.getAttribute("url");
            if (StringUtils.isBlank((String)url)) {
                throw new NullPointerException("url cannot be null");
            }
            repository.setUrl(url);
            wagon = this.getWagon(repository.getProtocol());
            this.configureWagon(wagon, repositoryId, server);
            break;
        }
        return wagon;
    }

    private Wagon getWagon(String protocol) throws UnsupportedProtocolException {
        if (protocol == null) {
            throw new UnsupportedProtocolException("Unspecified protocol");
        }
        try {
            return (Wagon)this.container.lookup(Wagon.class, protocol.toLowerCase(Locale.ENGLISH));
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedProtocolException("Cannot find wagon which supports the requested protocol: " + protocol, (Throwable)e);
        }
    }

    private static RepositoryPermissions getPermissions(String id, Settings settings) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        Server server = settings.getServer(id);
        if (server == null) {
            return null;
        }
        String filePerms = server.getFilePermissions();
        String dirPerms = server.getDirectoryPermissions();
        if (StringUtils.isBlank((String)filePerms) && StringUtils.isBlank((String)dirPerms)) {
            return null;
        }
        RepositoryPermissions permissions = new RepositoryPermissions();
        permissions.setFileMode(filePerms);
        permissions.setDirectoryMode(dirPerms);
        return permissions;
    }

    private static ProxyInfo getProxyInfo(Settings settings) {
        ProxyInfo proxyInfo = null;
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy settingsProxy = settings.getActiveProxy();
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(settingsProxy.getHost());
            proxyInfo.setType(settingsProxy.getProtocol());
            proxyInfo.setPort(settingsProxy.getPort());
            proxyInfo.setNonProxyHosts(settingsProxy.getNonProxyHosts());
            proxyInfo.setUserName(settingsProxy.getUsername());
            proxyInfo.setPassword(settingsProxy.getPassword());
        }
        return proxyInfo;
    }

    private Wagon configureWagon(Wagon wagon, String repositoryId, Settings settings) throws TransferFailedException {
        for (Server server : settings.getServers()) {
            String id = server.getId();
            if (id == null || !id.equals(repositoryId) || server.getConfiguration() == null) continue;
            this.configureWagon(wagon, repositoryId, server);
            break;
        }
        return wagon;
    }

    private Wagon configureWagon(Wagon wagon, String repositoryId, Server server) throws TransferFailedException {
        XmlPlexusConfiguration plexusConf = new XmlPlexusConfiguration((Xpp3Dom)server.getConfiguration());
        try {
            if (!(this.componentConfigurator instanceof BasicComponentConfigurator)) {
                this.componentConfigurator = new BasicComponentConfigurator();
            }
            this.componentConfigurator.configureComponent((Object)wagon, (PlexusConfiguration)plexusConf, (ClassRealm)this.getClass().getClassLoader());
        }
        catch (ComponentConfigurationException e) {
            throw new TransferFailedException("While configuring wagon for '" + repositoryId + "': Unable to apply wagon configuration.", (Throwable)e);
        }
        return wagon;
    }

    public AuthenticationInfo getAuthenticationInfo(String id, Settings settings) {
        List servers = settings.getServers();
        if (servers != null) {
            for (Server server : servers) {
                if (!id.equalsIgnoreCase(server.getId())) continue;
                SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
                server = result.getServer();
                AuthenticationInfo authInfo = new AuthenticationInfo();
                authInfo.setUserName(server.getUsername());
                authInfo.setPassword(server.getPassword());
                authInfo.setPrivateKey(server.getPrivateKey());
                authInfo.setPassphrase(server.getPassphrase());
                return authInfo;
            }
        }
        return new AuthenticationInfo();
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

