/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="lock-snapshots", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class LockSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    public final Pattern matchSnapshotRegex = Pattern.compile("-SNAPSHOT");

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
            this.lockSnapshots(pom, this.getProject().getDependencyManagement().getDependencies());
        }
        if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
            this.lockSnapshots(pom, this.getProject().getDependencies());
        }
        if (this.getProject().getParent() != null && this.isProcessingParent()) {
            this.lockParentSnapshot(pom, this.getProject().getParent());
        }
    }

    private void lockSnapshots(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException {
        for (Dependency dep : dependencies) {
            String lockedVersion;
            String version;
            Matcher versionMatcher;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (!this.isIncluded(this.toArtifact(dep)) || !(versionMatcher = this.matchSnapshotRegex.matcher(version = dep.getVersion())).find() || versionMatcher.end() != version.length() || version.equals(lockedVersion = this.resolveSnapshotVersion(dep)) || !PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, lockedVersion, this.getProject().getModel())) continue;
            this.getLog().info((CharSequence)("Locked " + this.toString(dep) + " to version " + lockedVersion));
        }
    }

    private void lockParentSnapshot(ModifiedPomXMLEventReader pom, MavenProject parent) throws XMLStreamException, MojoExecutionException {
        String lockedParentVersion;
        if (parent == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(parent)) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        Artifact parentArtifact = parent.getArtifact();
        String parentVersion = parentArtifact.getVersion();
        Matcher versionMatcher = this.matchSnapshotRegex.matcher(parentVersion);
        if (versionMatcher.find() && versionMatcher.end() == parentVersion.length() && !parentVersion.equals(lockedParentVersion = this.resolveSnapshotVersion(parentArtifact)) && PomHelper.setProjectParentVersion(pom, lockedParentVersion)) {
            this.getLog().info((CharSequence)("Locked parent " + parentArtifact.toString() + " to version " + lockedParentVersion));
        }
    }

    private String resolveSnapshotVersion(Artifact artifact) {
        this.getLog().debug((CharSequence)("Resolving snapshot version for artifact: " + artifact));
        String lockedVersion = artifact.getVersion();
        try {
            this.resolver.resolve(artifact, this.getProject().getRemoteArtifactRepositories(), this.localRepository);
            lockedVersion = artifact.getVersion();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        return lockedVersion;
    }

    private String resolveSnapshotVersion(Dependency dep) {
        this.getLog().debug((CharSequence)("Resolving snapshot version for dependency: " + dep));
        String lockedVersion = dep.getVersion();
        try {
            Artifact depArtifact = this.artifactFactory.createDependencyArtifact(dep.getGroupId(), dep.getArtifactId(), VersionRange.createFromVersionSpec((String)dep.getVersion()), dep.getType(), dep.getClassifier(), dep.getScope());
            this.resolver.resolve(depArtifact, this.getProject().getRemoteArtifactRepositories(), this.localRepository);
            lockedVersion = depArtifact.getVersion();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        return lockedVersion;
    }
}

