/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:sql-maven-plugin:1.4", 0);
        this.append(sb, "", 0);
        this.append(sb, "SQL Maven Plugin", 0);
        this.append(sb, "Execute SQL Statements", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "execute".equals(this.goal)) {
            this.append(sb, "sql:execute", 0);
            this.append(sb, "Executes SQL against a database.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autocommit (Default: false)", 2);
                this.append(sb, "Set to true to execute none-transactional SQL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "delimiter (Default: ;)", 2);
                this.append(sb, "Set the delimiter that separates SQL statements.", 3);
                this.append(sb, "", 0);
                this.append(sb, "delimiterType (Default: normal)", 2);
                this.append(sb, "The delimiter type takes two values - 'normal' and 'row'. Normal means that any occurrence of the delimiter terminate the SQL command whereas with row, only a line containing just the delimiter is recognized as the end of the command.\n\nFor example, set this to 'go' and delimiterType to 'row' for Sybase ASE or MS SQL Server.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "driver", 2);
                this.append(sb, "Database driver classname.", 3);
                this.append(sb, "", 0);
                this.append(sb, "driverProperties", 2);
                this.append(sb, "Additional key=value pairs separated by comma to be passed into JDBC driver.", 3);
                this.append(sb, "", 0);
                this.append(sb, "enableAnonymousPassword (Default: false)", 2);
                this.append(sb, "Ignore the password and use anonymous access. This may be useful for databases like MySQL which do not allow empty password parameters in the connection initialization.", 3);
                this.append(sb, "", 0);
                this.append(sb, "enableBlockMode", 2);
                this.append(sb, "Deprecated. used delimiterType instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "When true, the whole SQL content in sqlCommand, srcFiles and fileset are sent directly to JDBC in one SQL statement. This option is for executing database stored procedures/functions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "enableFiltering", 2);
                this.append(sb, "Set to true if you want to filter the srcFiles using system-, user- and project properties", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding to use when reading SQL statements from a file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeProcessing (Default: true)", 2);
                this.append(sb, "Argument to Statement.setEscapeProcessing If you want the driver to use regular SQL syntax then set this to false.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileset", 2);
                this.append(sb, "File(s) containing SQL statements to load.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Setting this parameter to true will force the execution of this mojo, even if it would get skipped usually.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepFormat (Default: false)", 2);
                this.append(sb, "Keep the format of an SQL block.", 3);
                this.append(sb, "", 0);
                this.append(sb, "onError (Default: abort)", 2);
                this.append(sb, "Action to perform if an error is found. Possible values are abort and continue.", 3);
                this.append(sb, "", 0);
                this.append(sb, "orderFile", 2);
                this.append(sb, "Set the order in which the SQL files will be executed. Possible values are ascending and descending. Any other value means that no sorting will be performed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDelimiter (Default: ,)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile", 2);
                this.append(sb, "Dump the SQL exection's output to a file. Default is stdout.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Database password. If not given, it will be looked up through settings.xml's server with ${settingsKey} as key.", 3);
                this.append(sb, "", 0);
                this.append(sb, "printResultSet", 2);
                this.append(sb, "Print SQL results.", 3);
                this.append(sb, "", 0);
                this.append(sb, "settingsKey", 2);
                this.append(sb, "Server's id in settings.xml to look up username and password. Defaults to ${url} if not given.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipOnConnectionError (Default: false)", 2);
                this.append(sb, "Skip execution when there is an error obtaining a connection. This is a special case to support databases, such as embedded Derby, that can shutdown the database via the URL (i.e. shutdown=true).", 3);
                this.append(sb, "", 0);
                this.append(sb, "sqlCommand", 2);
                this.append(sb, "SQL input commands separated by ${delimiter}.", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcFiles", 2);
                this.append(sb, "List of files containing SQL statements to load.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Database URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Database username. If not given, it will be looked up through settings.xml's server with ${settingsKey} as key.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "sql:help", 0);
            this.append(sb, "Display help information on sql-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0sql:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

