/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.rpm.LogStreamConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.Shell;

@Mojo(name="unpack", requiresProject=false, aggregator=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class RPMUnpackMojo
extends AbstractMojo {
    @Parameter(property="rpm.file", required=true)
    private File rpmFile;
    @Parameter(property="rpm.unpackDirectory", defaultValue="${project.build.directory}/rpm/unpack")
    private File unpackDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        this.unpackDirectory.getParentFile().mkdirs();
        Commandline cl = new Commandline(new Shell());
        cl.setWorkingDirectory(this.unpackDirectory);
        cl.setExecutable("sh");
        cl.createArg().setValue("-c");
        String cmd = "'rpm2cpio " + this.rpmFile + " | cpio -idm" + "'";
        if (this.getLog().isDebugEnabled()) {
            cmd = "'rpm2cpio " + this.rpmFile + " | cpio -idmv" + "'";
        }
        cl.createArg().setLine(cmd);
        LogStreamConsumer stdout = new LogStreamConsumer(1, this.getLog());
        LogStreamConsumer stderr = new LogStreamConsumer(1, this.getLog());
        try {
            int result;
            log.info((CharSequence)("Unpacking " + this.rpmFile + "to " + this.unpackDirectory + "..."));
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("About to execute '" + cl.toString() + "'"));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                throw new MojoExecutionException("RPM build execution returned: '" + result + "' executing '" + cl.toString() + "'");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to unpack the RPM", (Exception)((Object)e));
        }
    }
}

