/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.rpm.AbstractRPMMojo;
import org.codehaus.mojo.rpm.ArtifactMap;
import org.codehaus.mojo.rpm.Dependency;
import org.codehaus.mojo.rpm.FilteringDirectoryArchiver;
import org.codehaus.mojo.rpm.Mapping;
import org.codehaus.mojo.rpm.SoftlinkSource;
import org.codehaus.mojo.rpm.Source;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.StringUtils;

final class FileHelper {
    private static final List<String> EMPTY_STRING_LIST = new ArrayList<String>();
    private static final String DESTINATION_DIRECTORY_ERROR_MSG = "Source has a destination [{0}], but the location [{1}] does not refer to a file.";
    private static final Pattern MACRO_PATTERN = Pattern.compile("%\\{([^}]*)\\}");
    private final FilteringDirectoryArchiver copier;
    private final AbstractRPMMojo mojo;
    public static final String UNIX_FILE_SEPARATOR = "/";

    public FileHelper(AbstractRPMMojo mojo, FilteringDirectoryArchiver copier) {
        this.mojo = mojo;
        this.copier = copier;
    }

    public void installFiles() throws MojoExecutionException, MojoFailureException {
        File workarea = this.mojo.getWorkarea();
        File buildroot = this.mojo.getBuildroot();
        File icon = this.mojo.getIcon();
        if (icon != null) {
            File icondest = new File(workarea, "SOURCES");
            this.copySource(icon, null, icondest, null, null, false, false);
        }
        Log log = this.mojo.getLog();
        for (Mapping map : this.mojo.getMappings()) {
            Dependency dep;
            String destinationString = map.getDestination();
            String macroEvaluatedDestination = this.evaluateMacros(destinationString);
            File dest = new File(buildroot, macroEvaluatedDestination);
            map.setAbsoluteDestination(dest);
            if (map.isDirOnly()) {
                if (dest.exists()) continue;
                log.info((CharSequence)("Creating empty directory " + dest.getAbsolutePath()));
                if (dest.mkdirs()) continue;
                throw new MojoExecutionException("Unable to create " + dest.getAbsolutePath());
            }
            this.processSources(map, dest);
            ArtifactMap art = map.getArtifact();
            if (art != null) {
                List<Artifact> artlist = this.selectArtifacts(art);
                for (Artifact artifactInstance : artlist) {
                    this.copyArtifact(artifactInstance, dest, false);
                    map.addCopiedFileNameRelativeToDestination(artifactInstance.getFile().getName());
                }
            }
            if ((dep = map.getDependency()) != null) {
                List<Artifact> deplist = this.selectDependencies(dep);
                for (Artifact artifactInstance : deplist) {
                    String outputFileName = this.copyArtifact(artifactInstance, dest, dep.getStripVersion());
                    map.addCopiedFileNameRelativeToDestination(outputFileName);
                }
            }
            if (!map.getCopiedFileNamesRelativeToDestination().isEmpty()) continue;
            log.info((CharSequence)("Mapping empty with destination: " + dest.getName()));
            if (dest.exists()) continue;
            log.info((CharSequence)("Creating empty directory " + dest.getAbsolutePath()));
            if (dest.mkdirs()) continue;
            throw new MojoExecutionException("Unable to create " + dest.getAbsolutePath());
        }
    }

    private List<String> copySource(File src, String srcName, File dest, List<String> incl, List<String> excl, boolean filter, boolean dontUseDefaultExcludes) throws MojoExecutionException {
        try {
            this.copier.setDestFile(dest);
            if (src.isDirectory()) {
                String[] ia = null;
                if (incl != null) {
                    ia = incl.toArray(new String[0]);
                }
                String[] ea = null;
                if (excl != null) {
                    ea = excl.toArray(new String[0]);
                }
                DefaultFileSet fileset = new DefaultFileSet(src);
                fileset.setPrefix("");
                fileset.setIncludes(ia);
                fileset.setExcludes(ea);
                fileset.setIncludingEmptyDirectories(this.copier.getIncludeEmptyDirs());
                fileset.setUsingDefaultExcludes(!dontUseDefaultExcludes);
                this.copier.addFileSet((FileSet)fileset);
            } else {
                srcName = srcName != null ? srcName : src.getName();
                this.copier.addFile(src, srcName);
            }
            this.copier.setFilter(filter);
            this.copier.setFilterWrappers(this.mojo.getFilterWrappers());
            Map copiedFilesMap = this.copier.getFiles();
            this.copier.createArchive();
            ArrayList<String> copiedFiles = new ArrayList<String>(copiedFilesMap.size());
            for (String key : copiedFilesMap.keySet()) {
                if (key == null || key.length() <= 0) continue;
                copiedFiles.add(key);
            }
            this.copier.resetArchiver();
            return copiedFiles;
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to copy files for packaging: " + t.getMessage(), t);
        }
    }

    public static DefaultFileSet fileSet(File directory) {
        DefaultFileSet defaultFileSet = new DefaultFileSet(directory);
        return defaultFileSet;
    }

    private String copyArtifact(Artifact art, File dest, boolean stripVersion) throws MojoExecutionException {
        String outputFileName;
        if (art.getFile() == null) {
            Log log = this.mojo.getLog();
            log.warn((CharSequence)("Artifact " + art + " requested in configuration."));
            log.warn((CharSequence)"Plugin must be run in Maven's build lifecycle for this to work.");
            throw new MojoExecutionException("Unable to resolve artifact.");
        }
        if (stripVersion) {
            String classifier = art.getClassifier();
            outputFileName = art.getArtifactId();
            if (classifier != null) {
                outputFileName = outputFileName + '-';
                outputFileName = outputFileName + classifier;
            }
            outputFileName = outputFileName + '.';
            outputFileName = outputFileName + art.getType();
        } else {
            outputFileName = art.getFile().getName();
        }
        this.copySource(art.getFile(), outputFileName, dest, null, null, false, false);
        return outputFileName;
    }

    private List<Artifact> selectArtifacts(ArtifactMap am) {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        List<String> clist = am.getClassifiers();
        Artifact artifact = this.mojo.getArtifact();
        List<Artifact> attachedArtifacts = this.mojo.getAttachedArtifacts();
        if (clist == null) {
            retval.add(artifact);
            retval.addAll(attachedArtifacts);
        } else {
            if (clist.contains(null)) {
                retval.add(artifact);
            }
            for (Artifact aa : attachedArtifacts) {
                if (!aa.hasClassifier() || !clist.contains(aa.getClassifier())) continue;
                retval.add(aa);
            }
        }
        return retval;
    }

    private List<Artifact> selectDependencies(Dependency d) {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        List<Artifact> inc = d.getIncludes();
        List<Artifact> exc = d.getExcludes();
        Set deps = this.mojo.project.getArtifacts();
        if (deps == null || deps.isEmpty()) {
            return retval;
        }
        Log log = this.mojo.getLog();
        for (Artifact pdep : deps) {
            log.debug((CharSequence)("Dependency is " + pdep + " at " + pdep.getFile()));
            if (this.depMatcher(pdep, exc)) continue;
            log.debug((CharSequence)"--> not excluded");
            if (inc != null && !this.depMatcher(pdep, inc)) continue;
            log.debug((CharSequence)"--> included");
            retval.add(pdep);
        }
        return retval;
    }

    private void processSources(Mapping map, File dest) throws MojoExecutionException, MojoFailureException {
        List<Source> srcs;
        if (!dest.exists() && !dest.mkdirs()) {
            throw new MojoExecutionException("unable to create directory: " + dest.getAbsolutePath());
        }
        String relativeDestination = map.getDestination();
        if (!relativeDestination.endsWith(File.separator)) {
            relativeDestination = relativeDestination + File.separatorChar;
        }
        if ((srcs = map.getSources()) != null) {
            String targetArchComparison = this.mojo.getTargetArch().toLowerCase(Locale.ENGLISH);
            String targetOS = this.mojo.getTargetOS();
            Map<String, List<SoftlinkSource>> linkTargetToSources = this.mojo.getLinkTargetToSources();
            for (Source src : srcs) {
                File locationFile;
                if (!src.matchesArchitecture(targetArchComparison)) {
                    this.mojo.getLog().debug((CharSequence)("Source does not match target architecture: " + src.toString()));
                    continue;
                }
                if (!src.matchesOSName(targetOS)) {
                    this.mojo.getLog().debug((CharSequence)("Source does not match target os name: " + src.toString()));
                    continue;
                }
                File macroEvaluatedLocation = new File(this.evaluateMacros(src.getLocation()));
                src.setMacroEvaluatedLocation(macroEvaluatedLocation.getPath());
                File file = locationFile = macroEvaluatedLocation.isAbsolute() ? macroEvaluatedLocation : new File(this.mojo.project.getBasedir(), macroEvaluatedLocation.getPath());
                if (src instanceof SoftlinkSource) {
                    SoftlinkSource softlinkSource = (SoftlinkSource)src;
                    List<SoftlinkSource> sources = linkTargetToSources.get(relativeDestination);
                    if (sources == null) {
                        sources = new LinkedList<SoftlinkSource>();
                        linkTargetToSources.put(relativeDestination, sources);
                    }
                    sources.add(softlinkSource);
                    softlinkSource.setSourceMapping(map);
                    map.setHasSoftLinks(true);
                    continue;
                }
                if (locationFile.exists()) {
                    String destination = src.getDestination();
                    if (destination == null) {
                        map.addCopiedFileNamesRelativeToDestination(this.copySource(locationFile, null, dest, src.getIncludes(), src.getExcludes(), src.isFilter(), src.getNoDefaultExcludes()));
                        continue;
                    }
                    if (!locationFile.isFile()) {
                        throw new MojoExecutionException(MessageFormat.format(DESTINATION_DIRECTORY_ERROR_MSG, destination, macroEvaluatedLocation));
                    }
                    this.copySource(locationFile, destination, dest, EMPTY_STRING_LIST, EMPTY_STRING_LIST, src.isFilter(), src.getNoDefaultExcludes());
                    map.addCopiedFileNameRelativeToDestination(destination);
                    continue;
                }
                if (!src.getFailIfLocationNotExists()) {
                    this.mojo.getLog().warn((CharSequence)("Source location " + macroEvaluatedLocation + " does not exist, but failIfLocationNotExist was set to false"));
                    continue;
                }
                throw new MojoExecutionException("Source location " + macroEvaluatedLocation + " does not exist");
            }
        }
    }

    private String evaluateMacros(String value) throws MojoExecutionException {
        Matcher matcher = MACRO_PATTERN.matcher(value);
        StringBuffer newValue = new StringBuffer(value.length());
        while (matcher.find()) {
            String macro = matcher.group(1);
            String evaluatedValue = this.mojo.evaluateMacro(macro);
            matcher.appendReplacement(newValue, evaluatedValue.replaceAll("\\\\", "\\\\\\\\"));
        }
        matcher.appendTail(newValue);
        return newValue.toString();
    }

    private boolean depMatcher(Artifact dep, List<Artifact> list) {
        if (list == null) {
            return false;
        }
        Log log = this.mojo.getLog();
        for (Artifact item : list) {
            log.debug((CharSequence)("Compare " + dep + " to " + item));
            String groupId = item.getGroupId();
            if (!StringUtils.isEmpty((String)groupId) && !"*".equals(groupId) && !groupId.equals(dep.getGroupId())) continue;
            log.debug((CharSequence)"... Group matches");
            String artifactId = item.getArtifactId();
            if (!StringUtils.isEmpty((String)artifactId) && !"*".equals(artifactId) && !artifactId.equals(dep.getArtifactId())) continue;
            log.debug((CharSequence)"... Artifact matches");
            try {
                if (!item.getVersionRange().containsVersion(dep.getSelectedVersion())) continue;
                log.debug((CharSequence)"... Version matches");
                return true;
            }
            catch (OverConstrainedVersionException ocve) {
                log.debug((CharSequence)"... caught OverConstrainedVersionException");
            }
        }
        return false;
    }

    public static String toUnixPath(File path) {
        return FileHelper.toUnixPath(path.getAbsolutePath());
    }

    public static String toUnixPath(String path) {
        String[] tokens = StringUtils.split((String)(path = StringUtils.replace((String)path, (String)"\\", (String)UNIX_FILE_SEPARATOR)), (String)":");
        if (tokens.length == 2 && tokens[0].length() == 1) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("/cygdrive/").append(tokens[0]).append(tokens[1]);
            path = buffer.toString();
        }
        return path;
    }
}

