/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JJDocMojo
extends AbstractMavenReport {
    public static final String JJDOC_CLASSNAME = "jjdoc";
    private MavenProject project;
    private Renderer siteRenderer;
    private List pluginArtifacts;
    private File[] sourceDirectories;
    private File defaultSourceDirectory;
    private File defaultGeneratedSourceDirectory;
    private String jjdocDirectory;
    private File outputDirectory;
    private boolean text;
    private boolean oneTable;
    private String css;

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.toString();
    }

    protected File getJJDocOutputDirectory() {
        return new File(this.getReportOutputDirectory(), this.jjdocDirectory);
    }

    protected List getSourceDirectories() {
        ArrayList<File> directories = new ArrayList<File>();
        if (this.sourceDirectories != null && this.sourceDirectories.length > 0) {
            directories.addAll(Arrays.asList(this.sourceDirectories));
        } else {
            if (this.defaultSourceDirectory != null) {
                directories.add(this.defaultSourceDirectory);
            }
            if (this.defaultGeneratedSourceDirectory != null) {
                directories.add(this.defaultGeneratedSourceDirectory);
            }
        }
        return directories;
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jjdoc.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jjdoc.short.description");
    }

    public String getOutputName() {
        return this.jjdocDirectory + "/index";
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public void executeReport(Locale locale) {
        Sink sink = this.getSink();
        this.createReportHeader(this.getBundle(locale), sink);
        try {
            Iterator it = this.getSourceDirectories().iterator();
            while (it.hasNext()) {
                File sourceDirectory = (File)it.next();
                if (!sourceDirectory.isDirectory()) {
                    this.getLog().debug((CharSequence)("Skipping non-existing source directory: " + sourceDirectory));
                    continue;
                }
                this.getLog().debug((CharSequence)("Scanning source directory: " + sourceDirectory));
                Set grammarFiles = this.scanForGrammarFiles(sourceDirectory);
                Iterator i = grammarFiles.iterator();
                while (i.hasNext()) {
                    File grammarFile = (File)i.next();
                    URI relativeOutputFileURI = sourceDirectory.toURI().relativize(grammarFile.toURI());
                    String relativeOutputFileName = relativeOutputFileURI.toString().replaceAll("(.jj|.JJ)$", this.getOutputFileExtension());
                    File jjdocOutputFile = new File(this.getJJDocOutputDirectory(), relativeOutputFileName);
                    jjdocOutputFile.getParentFile().mkdirs();
                    String[] jjdocArgs = this.generateArgs(grammarFile, jjdocOutputFile);
                    this.forkJJDoc(jjdocArgs);
                    this.createReportLink(sink, sourceDirectory, grammarFile, relativeOutputFileName);
                }
            }
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
        this.createReportFooter(sink);
        sink.flush();
        sink.close();
    }

    public String getOutputFileExtension() {
        if (this.text) {
            return ".txt";
        }
        return ".html";
    }

    public void createReportHeader(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.jjdoc.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.jjdoc.title"));
        sink.sectionTitle1_();
        sink.text(bundle.getString("report.jjdoc.description"));
        sink.section1_();
        sink.lineBreak();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.jjdoc.table.heading"));
        sink.tableHeaderCell_();
        sink.tableRow_();
    }

    public void createReportLink(Sink sink, File sourceDirectory, File grammarFile, String linkPath) {
        sink.tableRow();
        sink.tableCell();
        if (linkPath.startsWith("/")) {
            linkPath = linkPath.substring(1);
        }
        sink.link(linkPath);
        String grammarFileRelativePath = sourceDirectory.toURI().relativize(grammarFile.toURI()).toString();
        if (grammarFileRelativePath.startsWith("/")) {
            grammarFileRelativePath = grammarFileRelativePath.substring(1);
        }
        sink.text(grammarFileRelativePath);
        sink.link_();
        sink.tableCell_();
        sink.tableRow_();
    }

    public void createReportFooter(Sink sink) {
        sink.table_();
        sink.body_();
    }

    public String[] generateArgs(File javaccFile, File outputFile) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-OUTPUT_FILE=" + outputFile);
        if (this.text) {
            argsList.add("-TEXT=true");
        }
        if (!this.oneTable) {
            argsList.add("-ONE_TABLE=false");
        }
        if (this.css != null && !this.css.equals("")) {
            argsList.add("-CSS=" + this.css);
        }
        argsList.add(javaccFile.getPath());
        return argsList.toArray(new String[argsList.size()]);
    }

    public Set scanForGrammarFiles(File sourceDirectory) throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping(".jj", this.getOutputFileExtension());
        SuffixMapping mappingCAP = new SuffixMapping(".JJ", this.getOutputFileExtension());
        HashSet<String> includes = new HashSet<String>(Arrays.asList("**/*.jj", "**/*.JJ"));
        Set excludes = Collections.EMPTY_SET;
        SimpleSourceInclusionScanner scanner = new SimpleSourceInclusionScanner(includes, excludes);
        scanner.addSourceMapping((SourceMapping)mapping);
        scanner.addSourceMapping((SourceMapping)mappingCAP);
        HashSet grammarFiles = new HashSet();
        try {
            grammarFiles.addAll(scanner.getIncludedSources(sourceDirectory, this.getJJDocOutputDirectory()));
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceDirectory + "' for stale grammars to reprocess.", (Exception)((Object)e));
        }
        return grammarFiles;
    }

    public String createJJDocClasspath() {
        StringBuffer classpath = new StringBuffer();
        Iterator i = this.pluginArtifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (!artifact.getArtifactId().contains("javacc")) continue;
            try {
                classpath.append(artifact.getFile().getCanonicalPath());
                classpath.append(File.pathSeparatorChar);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to get path to artifact: " + artifact.getFile()), (Throwable)e);
            }
        }
        return classpath.toString();
    }

    public void forkJJDoc(String[] jjdocArgs) throws MojoExecutionException {
        Commandline cli = new Commandline();
        String jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        cli.setExecutable(jvm);
        String[] jvmArgs = new String[]{"-cp", this.createJJDocClasspath(), JJDOC_CLASSNAME};
        cli.addArguments(jvmArgs);
        cli.addArguments(jjdocArgs);
        MojoLogStreamConsumer out = new MojoLogStreamConsumer();
        MojoLogStreamConsumer err = new MojoLogStreamConsumer(true);
        this.getLog().debug((CharSequence)"Forking Command Line: ");
        this.getLog().debug((CharSequence)cli.toString());
        this.getLog().debug((CharSequence)"");
        try {
            int returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            if (returnCode != 0) {
                throw new MojoExecutionException("There were errors while generating the jjdoc");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error while executing forked tests.", (Exception)((Object)e));
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jjdoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public class MojoLogStreamConsumer
    implements StreamConsumer {
        private boolean err = false;

        public MojoLogStreamConsumer() {
        }

        public MojoLogStreamConsumer(boolean error) {
            this.err = error;
        }

        public void consumeLine(String line) {
            if (this.err) {
                JJDocMojo.this.getLog().info((CharSequence)line);
            } else {
                JJDocMojo.this.getLog().debug((CharSequence)line);
            }
        }
    }
}

