/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.Range;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntRange
extends AbstractList<Integer>
implements Range<Integer> {
    private int from;
    private int to;
    private boolean reverse;

    public IntRange(int from, int to) {
        if (from > to) {
            this.from = to;
            this.to = from;
            this.reverse = true;
        } else {
            this.from = from;
            this.to = to;
        }
        if (this.to - this.from >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("range must have no more than 2147483647 elements");
        }
    }

    protected IntRange(int from, int to, boolean reverse) {
        if (from > to) {
            throw new IllegalArgumentException("'from' must be less than or equal to 'to'");
        }
        this.from = from;
        this.to = to;
        this.reverse = reverse;
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof IntRange ? this.equals((IntRange)that) : super.equals(that);
    }

    public boolean equals(IntRange that) {
        return that != null && this.reverse == that.reverse && this.from == that.from && this.to == that.to;
    }

    @Override
    public Comparable getFrom() {
        return Integer.valueOf(this.from);
    }

    @Override
    public Comparable getTo() {
        return Integer.valueOf(this.to);
    }

    public int getFromInt() {
        return this.from;
    }

    public int getToInt() {
        return this.to;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public boolean containsWithinBounds(Object o) {
        return this.contains(o);
    }

    @Override
    public Integer get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " should not be negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " too big for range: " + this);
        }
        int value = this.reverse ? this.to - index : index + this.from;
        return value;
    }

    @Override
    public int size() {
        return this.to - this.from + 1;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntRangeIterator();
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return new EmptyRange(Integer.valueOf(this.from));
        }
        return new IntRange(fromIndex + this.from, toIndex + this.from - 1, this.reverse);
    }

    @Override
    public String toString() {
        return this.reverse ? "" + this.to + ".." + this.from : "" + this.from + ".." + this.to;
    }

    @Override
    public String inspect() {
        return this.toString();
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            int i = integer;
            return i >= this.from && i <= this.to;
        }
        if (value instanceof BigInteger) {
            BigInteger bigint = (BigInteger)value;
            return bigint.compareTo(BigInteger.valueOf(this.from)) >= 0 && bigint.compareTo(BigInteger.valueOf(this.to)) <= 0;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection other) {
        if (other instanceof IntRange) {
            IntRange range = (IntRange)other;
            return this.from <= range.from && range.to <= this.to;
        }
        return super.containsAll(other);
    }

    @Override
    public void step(int step, Closure closure) {
        if (this.reverse) {
            step = -step;
        }
        if (step >= 0) {
            for (int value = this.from; value <= this.to; value += step) {
                closure.call(value);
            }
        } else {
            for (int value = this.to; value >= this.from; value += step) {
                closure.call(value);
            }
        }
    }

    @Override
    public List<Integer> step(int step) {
        IteratorClosureAdapter adapter = new IteratorClosureAdapter(this);
        this.step(step, adapter);
        return adapter.asList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntRangeIterator
    implements Iterator<Integer> {
        private int index;
        private int size;
        private int value;

        private IntRangeIterator() {
            this.size = IntRange.this.size();
            this.value = IntRange.this.reverse ? IntRange.this.to : IntRange.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Integer next() {
            if (this.index++ > 0) {
                if (this.index > this.size) {
                    return null;
                }
                this.value = IntRange.this.reverse ? --this.value : ++this.value;
            }
            return this.value;
        }

        @Override
        public void remove() {
            IntRange.this.remove(this.index);
        }
    }
}

